"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpaceSettings = getSpaceSettings;
exports.saveSpaceSettings = saveSpaceSettings;
var _common = require("@kbn/spaces-plugin/common");
var _server = require("@kbn/core/server");
var _constants = require("../../../common/constants");
var _app_context = require("../app_context");
var _constants2 = require("../../constants");
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function _getSavedObjectId(spaceId) {
  if (!spaceId || spaceId === _common.DEFAULT_SPACE_ID) {
    return `${_common.DEFAULT_SPACE_ID}${_constants.SPACE_SETTINGS_ID_SUFFIX}`;
  }
  return `${spaceId}${_constants.SPACE_SETTINGS_ID_SUFFIX}`;
}
async function getSpaceSettings(spaceId) {
  var _settings$attributes$, _settings$attributes, _settings$attributes2;
  const soClient = _app_context.appContextService.getInternalUserSOClientForSpaceId(spaceId);
  const settings = await soClient.get(_constants2.SPACE_SETTINGS_SAVED_OBJECT_TYPE, _getSavedObjectId(spaceId)).catch(err => {
    if (_server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
      return undefined;
    }
    throw err;
  });
  return {
    allowed_namespace_prefixes: (_settings$attributes$ = settings === null || settings === void 0 ? void 0 : (_settings$attributes = settings.attributes) === null || _settings$attributes === void 0 ? void 0 : _settings$attributes.allowed_namespace_prefixes) !== null && _settings$attributes$ !== void 0 ? _settings$attributes$ : [],
    managed_by: settings === null || settings === void 0 ? void 0 : (_settings$attributes2 = settings.attributes) === null || _settings$attributes2 === void 0 ? void 0 : _settings$attributes2.managed_by
  };
}
async function saveSpaceSettings({
  settings,
  spaceId,
  managedBy
}) {
  const soClient = _app_context.appContextService.getInternalUserSOClientForSpaceId(spaceId);
  const originalSettings = await getSpaceSettings(spaceId);
  if (originalSettings.managed_by && originalSettings.managed_by !== managedBy) {
    throw new _.FleetUnauthorizedError(`Settings are managed by: ${originalSettings.managed_by} and should be edited there`);
  }
  await soClient.update(_constants2.SPACE_SETTINGS_SAVED_OBJECT_TYPE, _getSavedObjectId(spaceId), settings, {
    upsert: settings
  });
}