"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAgentPolicySpaces = updateAgentPolicySpaces;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _common = require("@kbn/spaces-plugin/common");
var _constants = require("../../../common/constants");
var _app_context = require("../app_context");
var _agent_policy = require("../agent_policy");
var _constants2 = require("../../constants");
var _package_policy = require("../package_policy");
var _errors = require("../../errors");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateAgentPolicySpaces({
  agentPolicyId,
  currentSpaceId,
  newSpaceIds,
  authorizedSpaces
}) {
  var _existingPolicy$space, _existingPolicy$space2, _existingPolicy$space5, _existingPolicy$space6;
  const useSpaceAwareness = await (0, _helpers.isSpaceAwarenessEnabled)();
  if (!useSpaceAwareness || !newSpaceIds || newSpaceIds.length === 0) {
    return;
  }
  const esClient = _app_context.appContextService.getInternalUserESClient();
  const soClient = _app_context.appContextService.getInternalUserSOClientWithoutSpaceExtension();
  const currentSpaceSoClient = _app_context.appContextService.getInternalUserSOClientForSpaceId(currentSpaceId);
  const existingPolicy = await _agent_policy.agentPolicyService.get(currentSpaceSoClient, agentPolicyId);
  const existingPackagePolicies = await _package_policy.packagePolicyService.findAllForAgentPolicy(currentSpaceSoClient, agentPolicyId);
  if ((0, _fastDeepEqual.default)((_existingPolicy$space = existingPolicy === null || existingPolicy === void 0 ? void 0 : (_existingPolicy$space2 = existingPolicy.space_ids) === null || _existingPolicy$space2 === void 0 ? void 0 : _existingPolicy$space2.sort()) !== null && _existingPolicy$space !== void 0 ? _existingPolicy$space : [_common.DEFAULT_SPACE_ID], newSpaceIds.sort())) {
    return;
  }
  const spacesToAdd = newSpaceIds.filter(spaceId => {
    var _existingPolicy$space3, _existingPolicy$space4;
    return (_existingPolicy$space3 = !(existingPolicy !== null && existingPolicy !== void 0 && (_existingPolicy$space4 = existingPolicy.space_ids) !== null && _existingPolicy$space4 !== void 0 && _existingPolicy$space4.includes(spaceId))) !== null && _existingPolicy$space3 !== void 0 ? _existingPolicy$space3 : true;
  });
  const spacesToRemove = (_existingPolicy$space5 = existingPolicy === null || existingPolicy === void 0 ? void 0 : (_existingPolicy$space6 = existingPolicy.space_ids) === null || _existingPolicy$space6 === void 0 ? void 0 : _existingPolicy$space6.filter(spaceId => {
    var _newSpaceIds$includes;
    return (_newSpaceIds$includes = !newSpaceIds.includes(spaceId)) !== null && _newSpaceIds$includes !== void 0 ? _newSpaceIds$includes : true;
  })) !== null && _existingPolicy$space5 !== void 0 ? _existingPolicy$space5 : [];

  // Privileges check
  for (const spaceId of spacesToAdd) {
    if (!authorizedSpaces.includes(spaceId)) {
      throw new _errors.FleetError(`No enough permissions to create policies in space ${spaceId}`);
    }
  }
  for (const spaceId of spacesToRemove) {
    if (!authorizedSpaces.includes(spaceId)) {
      throw new _errors.FleetError(`No enough permissions to remove policies from space ${spaceId}`);
    }
  }
  const res = await soClient.updateObjectsSpaces([{
    id: agentPolicyId,
    type: _constants.AGENT_POLICY_SAVED_OBJECT_TYPE
  }, ...existingPackagePolicies.map(({
    id
  }) => ({
    id,
    type: _constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE
  }))], spacesToAdd, spacesToRemove, {
    refresh: 'wait_for',
    namespace: currentSpaceId
  });
  for (const soRes of res.objects) {
    if (soRes.error) {
      throw soRes.error;
    }
  }

  // Update fleet server index agents, enrollment api keys
  await esClient.updateByQuery({
    index: _constants2.ENROLLMENT_API_KEYS_INDEX,
    script: `ctx._source.namespaces = [${newSpaceIds.map(spaceId => `"${spaceId}"`).join(',')}]`,
    ignore_unavailable: true,
    refresh: true
  });
  await esClient.updateByQuery({
    index: _constants.AGENTS_INDEX,
    script: `ctx._source.namespaces = [${newSpaceIds.map(spaceId => `"${spaceId}"`).join(',')}]`,
    ignore_unavailable: true,
    refresh: true
  });
}