"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._getSettingsAPISchema = _getSettingsAPISchema;
exports._getSettingsValuesForAgentPolicy = _getSettingsValuesForAgentPolicy;
exports.getSettings = getSettings;
exports.getSettingsAPISchema = getSettingsAPISchema;
exports.getSettingsValuesForAgentPolicy = getSettingsValuesForAgentPolicy;
var _configSchema = require("@kbn/config-schema");
var _zodHelpers = require("@kbn/zod-helpers");
var _settings = require("../../../common/settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSettingsAPISchema(settingSection) {
  const settings = getSettings(settingSection);
  return _getSettingsAPISchema(settings);
}
function _getSettingsAPISchema(settings) {
  const validations = {};
  settings.forEach(setting => {
    if (!setting.api_field) {
      return;
    }
    const defaultValueRes = setting.schema.safeParse(undefined);
    const defaultValue = defaultValueRes.success ? defaultValueRes.data : undefined;
    if (defaultValue) {
      validations[setting.api_field.name] = _configSchema.schema.oneOf([_configSchema.schema.any({
        validate: val => {
          const res = setting.schema.safeParse(val);
          if (!res.success) {
            return (0, _zodHelpers.stringifyZodError)(res.error);
          }
        }
      }), _configSchema.schema.literal(null)], {
        defaultValue
      });
    } else {
      validations[setting.api_field.name] = _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.any({
        validate: val => {
          const res = setting.schema.safeParse(val);
          if (!res.success) {
            return (0, _zodHelpers.stringifyZodError)(res.error);
          }
        }
      })));
    }
  });
  const advancedSettingsValidations = {
    advanced_settings: _configSchema.schema.maybe(_configSchema.schema.object({
      ...validations
    }))
  };
  return advancedSettingsValidations;
}
function getSettingsValuesForAgentPolicy(settingSection, agentPolicy) {
  const settings = getSettings(settingSection);
  return _getSettingsValuesForAgentPolicy(settings, agentPolicy);
}
function _getSettingsValuesForAgentPolicy(settings, agentPolicy) {
  const settingsValues = {};
  settings.forEach(setting => {
    var _agentPolicy$advanced;
    if (!setting.api_field) {
      return;
    }
    const val = (_agentPolicy$advanced = agentPolicy.advanced_settings) === null || _agentPolicy$advanced === void 0 ? void 0 : _agentPolicy$advanced[setting.api_field.name];
    if (val) {
      settingsValues[setting.name] = val;
    }
  });
  return settingsValues;
}
function getSettings(settingSection) {
  if (settingSection === 'AGENT_POLICY_ADVANCED_SETTINGS') {
    return _settings.AGENT_POLICY_ADVANCED_SETTINGS;
  }
  throw new Error(`Invalid settings section ${settingSection}`);
}