"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanUpKibanaAssetsStep = cleanUpKibanaAssetsStep;
exports.stepInstallKibanaAssets = stepInstallKibanaAssets;
var _install = require("../../../kibana/assets/install");
var _utils = require("../../utils");
var _remove = require("../../remove");
var _types = require("../../../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallKibanaAssets(context) {
  const {
    savedObjectsClient,
    logger,
    installedPkg,
    packageInstallContext,
    spaceId
  } = context;
  const {
    packageInfo
  } = packageInstallContext;
  const {
    name: pkgName,
    title: pkgTitle
  } = packageInfo;
  const kibanaAssetPromise = (0, _utils.withPackageSpan)('Install Kibana assets', () => (0, _install.installKibanaAssetsAndReferencesMultispace)({
    savedObjectsClient,
    pkgName,
    pkgTitle,
    packageInstallContext,
    installedPkg,
    logger,
    spaceId,
    assetTags: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.asset_tags
  }));
  // Necessary to avoid async promise rejection warning
  // See https://stackoverflow.com/questions/40920179/should-i-refrain-from-handling-promise-rejection-asynchronously
  kibanaAssetPromise.catch(() => {});
  return {
    kibanaAssetPromise
  };
}
async function cleanUpKibanaAssetsStep(context) {
  var _installedPkg$attribu;
  const {
    logger,
    installedPkg,
    packageInstallContext,
    spaceId,
    retryFromLastState,
    force,
    initialState
  } = context;
  const {
    packageInfo
  } = packageInstallContext;

  // In case of retry clean up previous installed kibana assets
  if (!force && retryFromLastState && initialState === _types.INSTALL_STATES.INSTALL_KIBANA_ASSETS && installedPkg !== null && installedPkg !== void 0 && (_installedPkg$attribu = installedPkg.attributes) !== null && _installedPkg$attribu !== void 0 && _installedPkg$attribu.installed_kibana && installedPkg.attributes.installed_kibana.length > 0) {
    const {
      installed_kibana: installedObjects
    } = installedPkg.attributes;
    logger.debug('Retry transition - clean up Kibana assets first');
    await (0, _utils.withPackageSpan)('Retry transition - clean up Kibana assets first', async () => {
      await (0, _remove.deleteKibanaAssets)({
        installedObjects,
        spaceId,
        packageInfo
      });
    });
  }
}