"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPackageAssetsMapCache = getPackageAssetsMapCache;
exports.getPackageInfoCache = getPackageInfoCache;
exports.runWithCache = runWithCache;
exports.setPackageAssetsMapCache = setPackageAssetsMapCache;
exports.setPackageInfoCache = setPackageInfoCache;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _async_hooks = require("async_hooks");
var _lruCache = _interopRequireDefault(require("lru-cache"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cacheStore = new _async_hooks.AsyncLocalStorage();
const PACKAGE_INFO_CACHE_SIZE = 20;
const PACKAGE_ASSETS_MAP_CACHE_SIZE = 1;
class CacheSession {
  constructor() {
    (0, _defineProperty2.default)(this, "_packageInfoCache", void 0);
    (0, _defineProperty2.default)(this, "_packageAssetsMap", void 0);
  }
  getPackageInfoCache() {
    if (!this._packageInfoCache) {
      this._packageInfoCache = new _lruCache.default({
        max: PACKAGE_INFO_CACHE_SIZE
      });
    }
    return this._packageInfoCache;
  }
  getPackageAssetsMapCache() {
    if (!this._packageAssetsMap) {
      this._packageAssetsMap = new _lruCache.default({
        max: PACKAGE_ASSETS_MAP_CACHE_SIZE
      });
    }
    return this._packageAssetsMap;
  }
}
function getPackageInfoCache(pkgName, pkgVersion) {
  var _cacheStore$getStore, _cacheStore$getStore$;
  return (_cacheStore$getStore = cacheStore.getStore()) === null || _cacheStore$getStore === void 0 ? void 0 : (_cacheStore$getStore$ = _cacheStore$getStore.getPackageInfoCache()) === null || _cacheStore$getStore$ === void 0 ? void 0 : _cacheStore$getStore$.get(`${pkgName}:${pkgVersion}`);
}
function setPackageInfoCache(pkgName, pkgVersion, packageInfo) {
  var _cacheStore$getStore2, _cacheStore$getStore3;
  return (_cacheStore$getStore2 = cacheStore.getStore()) === null || _cacheStore$getStore2 === void 0 ? void 0 : (_cacheStore$getStore3 = _cacheStore$getStore2.getPackageInfoCache()) === null || _cacheStore$getStore3 === void 0 ? void 0 : _cacheStore$getStore3.set(`${pkgName}:${pkgVersion}`, packageInfo);
}
function getPackageAssetsMapCache(pkgName, pkgVersion) {
  var _cacheStore$getStore4, _cacheStore$getStore5;
  return (_cacheStore$getStore4 = cacheStore.getStore()) === null || _cacheStore$getStore4 === void 0 ? void 0 : (_cacheStore$getStore5 = _cacheStore$getStore4.getPackageAssetsMapCache()) === null || _cacheStore$getStore5 === void 0 ? void 0 : _cacheStore$getStore5.get(`${pkgName}:${pkgVersion}`);
}
function setPackageAssetsMapCache(pkgName, pkgVersion, assetsMap) {
  var _cacheStore$getStore6, _cacheStore$getStore7;
  return (_cacheStore$getStore6 = cacheStore.getStore()) === null || _cacheStore$getStore6 === void 0 ? void 0 : (_cacheStore$getStore7 = _cacheStore$getStore6.getPackageAssetsMapCache()) === null || _cacheStore$getStore7 === void 0 ? void 0 : _cacheStore$getStore7.set(`${pkgName}:${pkgVersion}`, assetsMap);
}
async function runWithCache(cb) {
  const cache = new CacheSession();
  return cacheStore.run(cache, cb);
}