"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAgentTags = updateAgentTags;
var _errors = require("../../errors");
var _constants = require("../../constants");
var _agent_namespaces = require("../spaces/agent_namespaces");
var _get_current_namespace = require("../spaces/get_current_namespace");
var _crud = require("./crud");
var _update_agent_tags_action_runner = require("./update_agent_tags_action_runner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateAgentTags(soClient, esClient, options, tagsToAdd, tagsToRemove) {
  const currentSpaceId = (0, _get_current_namespace.getCurrentNamespace)(soClient);
  const outgoingErrors = {};
  const givenAgents = [];
  if ('agentIds' in options) {
    const maybeAgents = await (0, _crud.getAgentsById)(esClient, soClient, options.agentIds);
    for (const maybeAgent of maybeAgents) {
      if ('notFound' in maybeAgent) {
        outgoingErrors[maybeAgent.id] = new _errors.AgentReassignmentError(`Cannot find agent ${maybeAgent.id}`);
      } else {
        givenAgents.push(maybeAgent);
      }
    }
  } else if ('kuery' in options) {
    var _options$batchSize, _options$showInactive;
    const batchSize = (_options$batchSize = options.batchSize) !== null && _options$batchSize !== void 0 ? _options$batchSize : _constants.SO_SEARCH_LIMIT;
    const namespaceFilter = await (0, _agent_namespaces.agentsKueryNamespaceFilter)(currentSpaceId);
    const filters = namespaceFilter ? [namespaceFilter] : [];
    if (options.kuery !== '') {
      filters.push(options.kuery);
    }
    if (tagsToAdd.length === 1 && tagsToRemove.length === 0) {
      filters.push(`NOT (tags:${tagsToAdd[0]})`);
    } else if (tagsToRemove.length === 1 && tagsToAdd.length === 0) {
      filters.push(`tags:${tagsToRemove[0]}`);
    }
    const kuery = filters.map(filter => `(${filter})`).join(' AND ');
    const pitId = await (0, _crud.openPointInTime)(esClient);

    // calculate total count
    const res = await (0, _crud.getAgentsByKuery)(esClient, soClient, {
      kuery,
      showInactive: (_options$showInactive = options.showInactive) !== null && _options$showInactive !== void 0 ? _options$showInactive : false,
      perPage: 0,
      pitId
    });
    return await new _update_agent_tags_action_runner.UpdateAgentTagsActionRunner(esClient, soClient, {
      ...options,
      spaceId: currentSpaceId,
      kuery,
      tagsToAdd,
      tagsToRemove,
      batchSize,
      total: res.total
    }, {
      pitId
    }).runActionAsyncWithRetry();
  }
  return await (0, _update_agent_tags_action_runner.updateTagsBatch)(soClient, esClient, givenAgents, outgoingErrors, {
    tagsToAdd,
    tagsToRemove,
    spaceId: currentSpaceId
  });
}