"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStandaloneAgentApiKeyHandler = void 0;
var _api_keys = require("../../services/api_keys");
var _create_standalone_agent_api_key = require("../../services/api_keys/create_standalone_agent_api_key");
var _errors = require("../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createStandaloneAgentApiKeyHandler = async (context, request, response) => {
  try {
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const canCreate = await (0, _create_standalone_agent_api_key.canCreateStandaloneAgentApiKey)(esClient);
    if (!canCreate) {
      throw new _errors.FleetUnauthorizedError(`Missing permissions to create standalone API key, You need ${_create_standalone_agent_api_key.INDEX_PRIVILEGES.privileges.join(', ')} for indices ${_create_standalone_agent_api_key.INDEX_PRIVILEGES.names.join(', ')}`);
    }
    const key = await (0, _api_keys.createStandaloneAgentApiKey)(esClient, request.body.name);
    return response.ok({
      body: {
        item: key
      }
    });
  } catch (error) {
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.createStandaloneAgentApiKeyHandler = createStandaloneAgentApiKeyHandler;