"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetPreconfigurationHandler = exports.resetOnePreconfigurationHandler = void 0;
var _errors = require("../../errors");
var _reset_agent_policies = require("../../services/preconfiguration/reset_agent_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resetOnePreconfigurationHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const soClient = coreContext.savedObjects.client;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  try {
    await (0, _reset_agent_policies.resetPreconfiguredAgentPolicies)(soClient, esClient, request.params.agentPolicyId);
    return response.ok({});
  } catch (error) {
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.resetOnePreconfigurationHandler = resetOnePreconfigurationHandler;
const resetPreconfigurationHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const soClient = coreContext.savedObjects.client;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  try {
    await (0, _reset_agent_policies.resetPreconfiguredAgentPolicies)(soClient, esClient);
    return response.ok({});
  } catch (error) {
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.resetPreconfigurationHandler = resetPreconfigurationHandler;