"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePoliciesPage = void 0;
var _queryString = require("query-string");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../constants");
var _components = require("../../../../../components");
var _side_bar_column = require("../../../components/side_bar_column");
var _package_policy_agents_cell = require("./components/package_policy_agents_cell");
var _use_package_policies_with_agent_policy = require("./use_package_policies_with_agent_policy");
var _persona = require("./persona");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationDetailsLink = /*#__PURE__*/(0, _react.memo)(({
  packagePolicy
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    className: "eui-textTruncate",
    "data-test-subj": "integrationNameLink",
    href: getHref('integration_policy_edit', {
      packagePolicyId: packagePolicy.id
    })
  }, packagePolicy.name);
});
const PackagePoliciesPage = ({
  name,
  version
}) => {
  var _packageAndAgentPolic, _packageAndAgentPolic2, _packagePolicy$packag, _packagePolicy$packag2;
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const queryParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const agentPolicyIdFromParams = (0, _react.useMemo)(() => queryParams.get('addAgentToPolicyId'), [queryParams]);
  const showAddAgentHelpForPolicyId = (0, _react.useMemo)(() => queryParams.get('showAddAgentHelpForPolicyId'), [queryParams]);
  const [flyoutOpenForPolicyId, setFlyoutOpenForPolicyId] = (0, _react.useState)(agentPolicyIdFromParams);
  const [selectedTableIndex, setSelectedTableIndex] = (0, _react.useState)();
  const {
    getPath,
    getHref
  } = (0, _hooks.useLink)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const packageInstallStatus = getPackageInstallStatus(name);
  const {
    pagination,
    pageSizeOptions,
    setPagination
  } = (0, _hooks.useUrlPagination)();
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const {
    data,
    isLoading,
    resendRequest: refreshPolicies
  } = (0, _use_package_policies_with_agent_policy.usePackagePoliciesWithAgentPolicy)({
    page: pagination.currentPage,
    perPage: pagination.pageSize,
    kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: ${name}`
  });
  const {
    isPackagePolicyUpgradable
  } = (0, _hooks.useIsPackagePolicyUpgradable)();
  const canWriteIntegrationPolicies = (0, _hooks.useAuthz)().integrations.writeIntegrationPolicies;
  const canReadIntegrationPolicies = (0, _hooks.useAuthz)().integrations.readIntegrationPolicies;
  const canReadAgentPolicies = (0, _hooks.useAuthz)().fleet.readAgentPolicies;
  const packageAndAgentPolicies = (0, _react.useMemo)(() => {
    if (!(data !== null && data !== void 0 && data.items)) {
      return [];
    }
    const newPolicies = data.items.map(({
      agentPolicies,
      packagePolicy
    }, index) => {
      const hasUpgrade = isPackagePolicyUpgradable(packagePolicy);
      return {
        agentPolicies,
        packagePolicy: {
          ...packagePolicy,
          hasUpgrade
        },
        rowIndex: index
      };
    });
    return newPolicies;
  }, [data === null || data === void 0 ? void 0 : data.items, isPackagePolicyUpgradable]);
  const showAddAgentHelpForPackagePolicyId = (_packageAndAgentPolic = packageAndAgentPolicies.find(({
    agentPolicies
  }) => agentPolicies.find(agentPolicy => agentPolicy.id === showAddAgentHelpForPolicyId))) === null || _packageAndAgentPolic === void 0 ? void 0 : (_packageAndAgentPolic2 = _packageAndAgentPolic.packagePolicy) === null || _packageAndAgentPolic2 === void 0 ? void 0 : _packageAndAgentPolic2.id;
  // Handle the "add agent" link displayed in post-installation toast notifications in the case
  // where a user is clicking the link while on the package policies listing page
  (0, _react.useEffect)(() => {
    const unlisten = history.listen(location => {
      const params = new URLSearchParams(location.search);
      const addAgentToPolicyId = params.get('addAgentToPolicyId');
      if (addAgentToPolicyId) {
        setFlyoutOpenForPolicyId(addAgentToPolicyId);
      }
    });
    return () => unlisten();
  }, [history]);
  const handleTableOnChange = (0, _react.useCallback)(({
    page
  }) => {
    setPagination({
      currentPage: page.index + 1,
      pageSize: page.size
    });
  }, [setPagination]);
  const canShowMultiplePoliciesCell = canUseMultipleAgentPolicies && canReadIntegrationPolicies && canReadAgentPolicies;
  const columns = (0, _react.useMemo)(() => [{
    field: 'packagePolicy.name',
    name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.name', {
      defaultMessage: 'Integration policy'
    }),
    render(_, {
      agentPolicies,
      packagePolicy
    }) {
      return /*#__PURE__*/_react.default.createElement(IntegrationDetailsLink, {
        packagePolicy: packagePolicy,
        agentPolicies: agentPolicies
      });
    }
  }, {
    field: 'packagePolicy.package.version',
    name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.version', {
      defaultMessage: 'Version'
    }),
    render(_version, {
      agentPolicies,
      packagePolicy
    }) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        wrap: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textNoWrap",
        "data-test-subj": "packageVersionText"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.integrationList.packageVersion",
        defaultMessage: "v{version}",
        values: {
          version: _version
        }
      }))), agentPolicies.length > 0 && packagePolicy.hasUpgrade && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        minWidth: "0",
        href: `${getHref('upgrade_package_policy', {
          policyId: agentPolicies[0].id,
          packagePolicyId: packagePolicy.id
        })}?from=integrations-policy-list`,
        "data-test-subj": "integrationPolicyUpgradeBtn",
        isDisabled: !canWriteIntegrationPolicies
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.packagePoliciesTable.upgradeButton",
        defaultMessage: "Upgrade"
      }))));
    }
  }, {
    field: 'packagePolicy.policy_ids',
    name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.agentPolicy', {
      defaultMessage: 'Agent policies'
    }),
    truncateText: true,
    render(ids, {
      agentPolicies,
      packagePolicy
    }) {
      return agentPolicies.length > 0 ? canShowMultiplePoliciesCell ? /*#__PURE__*/_react.default.createElement(_components.MultipleAgentPoliciesSummaryLine, {
        policies: agentPolicies,
        packagePolicyId: packagePolicy.id,
        onAgentPoliciesChange: refreshPolicies
      }) : /*#__PURE__*/_react.default.createElement(_components.AgentPolicySummaryLine, {
        policy: agentPolicies[0]
      }) : ids.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.integrationList.noAgentPolicies",
        defaultMessage: "No agent policies"
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "warning"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.integrationList.agentPolicyDeletedWarning",
        defaultMessage: "Policy not found"
      }));
    }
  }, {
    field: 'packagePolicy.updated_by',
    name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.updatedBy', {
      defaultMessage: 'Last updated by'
    }),
    truncateText: true,
    render(updatedBy) {
      return /*#__PURE__*/_react.default.createElement(_persona.Persona, {
        size: "s",
        name: updatedBy,
        title: updatedBy
      });
    }
  }, {
    field: 'packagePolicy.updated_at',
    name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.updatedAt', {
      defaultMessage: 'Last updated'
    }),
    truncateText: true,
    render(updatedAt) {
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "eui-textTruncate",
        title: updatedAt
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: updatedAt
      }));
    }
  }, {
    field: '',
    name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.agentCount', {
      defaultMessage: 'Agents'
    }),
    render({
      agentPolicies,
      packagePolicy,
      rowIndex
    }) {
      if (agentPolicies.length === 0) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: "subdued",
          size: "xs"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetails.integrationList.noAgents",
          defaultMessage: "No agents"
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_package_policy_agents_cell.PackagePolicyAgentsCell, {
        agentPolicies: agentPolicies,
        onAddAgent: () => {
          setSelectedTableIndex(rowIndex);
          setFlyoutOpenForPolicyId(agentPolicies[0].id);
        },
        hasHelpPopover: showAddAgentHelpForPackagePolicyId === packagePolicy.id
      });
    }
  }, {
    field: '',
    name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.actions', {
      defaultMessage: 'Actions'
    }),
    width: '8ch',
    align: 'right',
    render({
      agentPolicies,
      packagePolicy
    }) {
      const agentPolicy = agentPolicies[0]; // TODO: handle multiple agent policies
      return /*#__PURE__*/_react.default.createElement(_components.PackagePolicyActionsMenu, {
        agentPolicies: agentPolicies,
        packagePolicy: packagePolicy,
        showAddAgent: true,
        upgradePackagePolicyHref: agentPolicy ? `${getHref('upgrade_package_policy', {
          policyId: agentPolicy.id,
          packagePolicyId: packagePolicy.id
        })}?from=integrations-policy-list` : undefined
      });
    }
  }], [getHref, canWriteIntegrationPolicies, canShowMultiplePoliciesCell, showAddAgentHelpForPackagePolicyId, refreshPolicies]);
  const noItemsMessage = (0, _react.useMemo)(() => {
    return isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.loadingPoliciesMessage",
      defaultMessage: "Loading integration policies\u2026"
    }) : undefined;
  }, [isLoading]);
  const tablePagination = (0, _react.useMemo)(() => {
    var _data$total;
    return {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0,
      pageSizeOptions
    };
  }, [data === null || data === void 0 ? void 0 : data.total, pageSizeOptions, pagination.currentPage, pagination.pageSize]);

  // if they arrive at this page and the package is not installed, send them to overview
  // this happens if they arrive with a direct url or they uninstall while on this tab
  // Check flyoutOpenForPolicyId otherwise right after installing a new integration the flyout won't open
  if (packageInstallStatus.status !== _types.InstallStatus.installed && !flyoutOpenForPolicyId) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: getPath('integration_details_overview', {
        pkgkey: `${name}-${version}`
      })
    });
  }
  const selectedPolicies = selectedTableIndex !== undefined ? packageAndAgentPolicies[selectedTableIndex] : undefined;
  const agentPolicies = selectedPolicies === null || selectedPolicies === void 0 ? void 0 : selectedPolicies.agentPolicies;
  const packagePolicy = selectedPolicies === null || selectedPolicies === void 0 ? void 0 : selectedPolicies.packagePolicy;
  const flyoutPolicy = (agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.length) === 1 ? agentPolicies[0] : undefined;
  return /*#__PURE__*/_react.default.createElement(_hooks.AgentPolicyRefreshContext.Provider, {
    value: {
      refresh: refreshPolicies
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_side_bar_column.SideBarColumn, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: packageAndAgentPolicies || [],
    columns: columns,
    loading: isLoading,
    "data-test-subj": "integrationPolicyTable",
    pagination: tablePagination,
    onChange: handleTableOnChange,
    noItemsMessage: noItemsMessage
  }))), flyoutOpenForPolicyId && agentPolicies && !isLoading && /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
    onClose: () => {
      setFlyoutOpenForPolicyId(null);
      const {
        addAgentToPolicyId,
        ...rest
      } = (0, _queryString.parse)(search);
      history.replace({
        search: (0, _queryString.stringify)(rest)
      });
    },
    agentPolicy: flyoutPolicy,
    selectedAgentPolicies: agentPolicies,
    isIntegrationFlow: true,
    installedPackagePolicy: {
      name: (packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) || '',
      version: (packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.version) || ''
    }
  }));
};
exports.PackagePoliciesPage = PackagePoliciesPage;