"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerMissingEncryptionKeyCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetServerMissingEncryptionKeyCallout = ({
  onClickHandler
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "missingEncryptionKeyCallout",
    iconType: "iInCircle",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.missingEncryptionKeyCallout.title",
      defaultMessage: "Set up encryption key"
    })
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "missingEncryptionKeyBody"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.missingEncryptionKeyCallout.message",
    defaultMessage: "An encryption key will make your environment more secure. Click {link} to learn how to set up an encryption key.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.kibana.secureSavedObject,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.missingEncryptionKeyCallout.helpLink",
        defaultMessage: "here"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    color: "warning",
    onClick: onClickHandler
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.missingEncryptionKeyCallout.dismiss",
    defaultMessage: "Dismiss"
  })));
};
exports.FleetServerMissingEncryptionKeyCallout = FleetServerMissingEncryptionKeyCallout;