"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsOverviewSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
var _services = require("../../../../../services");
var _components = require("../../../../../components");
var _components2 = require("../../../components");
var _tags = require("../../../components/tags");
var _agent_metrics = require("../../../services/agent_metrics");
var _agent_dashboard_link = require("../agent_dashboard_link");
var _agent_upgrade_status = require("../../../agent_list_page/components/agent_upgrade_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allows child text to be truncated
const FlexItemWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 0px;
`;
const AgentDetailsOverviewSection = exports.AgentDetailsOverviewSection = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicy
}) => {
  var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3, _agent$local_metadata4, _agent$local_metadata5, _agent$local_metadata6, _agent$local_metadata7, _agent$local_metadata8, _agent$local_metadata9, _agent$local_metadata10, _agent$local_metadata11, _agent$local_metadata12, _agent$local_metadata13, _agent$local_metadata14, _agent$local_metadata15, _agentPolicy$monitori, _agentPolicy$monitori2, _agent$tags, _agent$tags2;
  const latestAgentVersion = (0, _hooks.useAgentVersion)();
  const {
    displayAgentMetrics
  } = _services.ExperimentalFeaturesService.get();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, displayAgentMetrics && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, [{
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentDetails.cpuTooltip",
        defaultMessage: "Average CPU usage in the last 5 minutes"
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.cpuTitle",
      defaultMessage: "CPU"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    }))),
    description: (0, _agent_metrics.formatAgentCPU)(agent.metrics, agentPolicy)
  }, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentDetails.memoryTooltip",
        defaultMessage: "Average memory usage in the last 5 minutes"
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.memoryTitle",
      defaultMessage: "Memory"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    }))),
    description: (0, _agent_metrics.formatAgentMemory)(agent.metrics, agentPolicy)
  }].map(({
    title,
    description
  }) => {
    const tooltip = typeof description === 'string' && description.length > 20 ? description : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
      grow: 8
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, title)), /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
      grow: 4
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: tooltip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textTruncate"
    }, description))));
  }))), /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_agent_dashboard_link.AgentDashboardLink, {
    agent: agent,
    agentPolicy: agentPolicy
  }))))), [{
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.statusLabel', {
      defaultMessage: 'Status'
    }),
    description: /*#__PURE__*/_react.default.createElement(_components2.AgentHealth, {
      agent: agent,
      fromDetails: true
    })
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.lastActivityLabel', {
      defaultMessage: 'Last activity'
    }),
    description: agent.last_checkin ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: new Date(agent.last_checkin)
    }) : '-'
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.lastCheckinMessageLabel', {
      defaultMessage: 'Last checkin message'
    }),
    description: agent.last_checkin_message ? agent.last_checkin_message : '-'
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.agentIdLabel', {
      defaultMessage: 'Agent ID'
    }),
    description: agent.id
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.agentPolicyLabel', {
      defaultMessage: 'Agent policy'
    }),
    description: agentPolicy ? /*#__PURE__*/_react.default.createElement(_components.AgentPolicySummaryLine, {
      policy: agentPolicy,
      agent: agent
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    })
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.versionLabel', {
      defaultMessage: 'Agent version'
    }),
    description: typeof ((_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.version) === 'string' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      style: {
        minWidth: 0
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "eui-textNoWrap"
    }, agent.local_metadata.elastic.agent.version), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_agent_upgrade_status.AgentUpgradeStatus, {
      isAgentUpgradable: !!((agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed) !== true && (0, _services.isAgentUpgradeable)(agent)),
      agent: agent,
      latestAgentVersion: latestAgentVersion
    }))) : '-'
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.hostNameLabel', {
      defaultMessage: 'Host name'
    }),
    description: typeof ((_agent$local_metadata4 = agent.local_metadata) === null || _agent$local_metadata4 === void 0 ? void 0 : (_agent$local_metadata5 = _agent$local_metadata4.host) === null || _agent$local_metadata5 === void 0 ? void 0 : _agent$local_metadata5.hostname) === 'string' ? agent.local_metadata.host.hostname : '-'
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.hostIdLabel', {
      defaultMessage: 'Host ID'
    }),
    description: typeof ((_agent$local_metadata6 = agent.local_metadata) === null || _agent$local_metadata6 === void 0 ? void 0 : (_agent$local_metadata7 = _agent$local_metadata6.host) === null || _agent$local_metadata7 === void 0 ? void 0 : _agent$local_metadata7.id) === 'string' ? agent.local_metadata.host.id : '-'
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.logLevel', {
      defaultMessage: 'Logging level'
    }),
    description: typeof ((_agent$local_metadata8 = agent.local_metadata) === null || _agent$local_metadata8 === void 0 ? void 0 : (_agent$local_metadata9 = _agent$local_metadata8.elastic) === null || _agent$local_metadata9 === void 0 ? void 0 : (_agent$local_metadata10 = _agent$local_metadata9.agent) === null || _agent$local_metadata10 === void 0 ? void 0 : _agent$local_metadata10.log_level) === 'string' ? agent.local_metadata.elastic.agent.log_level : '-'
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.privilegeModeLabel', {
      defaultMessage: 'Privilege mode'
    }),
    description: agent.local_metadata.elastic.agent.unprivileged === true ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.privilegeModeUnprivilegedText",
      defaultMessage: "Running as non-root"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.privilegeModePrivilegedText",
      defaultMessage: "Running as root"
    })
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.releaseLabel', {
      defaultMessage: 'Agent release'
    }),
    description: typeof ((_agent$local_metadata11 = agent.local_metadata) === null || _agent$local_metadata11 === void 0 ? void 0 : (_agent$local_metadata12 = _agent$local_metadata11.elastic) === null || _agent$local_metadata12 === void 0 ? void 0 : (_agent$local_metadata13 = _agent$local_metadata12.agent) === null || _agent$local_metadata13 === void 0 ? void 0 : _agent$local_metadata13.snapshot) === 'boolean' ? agent.local_metadata.elastic.agent.snapshot === true ? 'snapshot' : 'stable' : '-'
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.platformLabel', {
      defaultMessage: 'Platform'
    }),
    description: typeof ((_agent$local_metadata14 = agent.local_metadata) === null || _agent$local_metadata14 === void 0 ? void 0 : (_agent$local_metadata15 = _agent$local_metadata14.os) === null || _agent$local_metadata15 === void 0 ? void 0 : _agent$local_metadata15.platform) === 'string' ? agent.local_metadata.os.platform : '-'
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.monitorLogsLabel', {
      defaultMessage: 'Monitor logs'
    }),
    description: Array.isArray(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.monitoring_enabled) ? agentPolicy !== null && agentPolicy !== void 0 && (_agentPolicy$monitori = agentPolicy.monitoring_enabled) !== null && _agentPolicy$monitori !== void 0 && _agentPolicy$monitori.includes('logs') ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.monitorLogsEnabledText",
      defaultMessage: "Enabled"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.monitorLogsDisabledText",
      defaultMessage: "Disabled"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    })
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.monitorMetricsLabel', {
      defaultMessage: 'Monitor metrics'
    }),
    description: Array.isArray(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.monitoring_enabled) ? agentPolicy !== null && agentPolicy !== void 0 && (_agentPolicy$monitori2 = agentPolicy.monitoring_enabled) !== null && _agentPolicy$monitori2 !== void 0 && _agentPolicy$monitori2.includes('metrics') ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.monitorMetricsEnabledText",
      defaultMessage: "Enabled"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.monitorMetricsDisabledText",
      defaultMessage: "Disabled"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    })
  }, {
    title: _i18n.i18n.translate('xpack.fleet.agentDetails.tagsLabel', {
      defaultMessage: 'Tags'
    }),
    description: ((_agent$tags = agent.tags) !== null && _agent$tags !== void 0 ? _agent$tags : []).length > 0 ? /*#__PURE__*/_react.default.createElement(_tags.Tags, {
      tags: (_agent$tags2 = agent.tags) !== null && _agent$tags2 !== void 0 ? _agent$tags2 : []
    }) : '-'
  }].map(({
    title,
    description
  }) => {
    const tooltip = typeof description === 'string' && description.length > 20 ? description : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
      grow: 3
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, title)), /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
      grow: 7
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: tooltip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textTruncate"
    }, description))));
  }))));
});