"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsActionMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../common/services");
var _agent_status = require("../../../../../../../common/services/agent_status");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _components2 = require("../../components");
var _hooks2 = require("../hooks");
var _services2 = require("../../../../services");
var _agent_request_diagnostics_modal = require("../../components/agent_request_diagnostics_modal");
var _agent_details_json_flyout = require("./agent_details_json_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentDetailsActionMenu = exports.AgentDetailsActionMenu = /*#__PURE__*/(0, _react.memo)(({
  agent,
  assignFlyoutOpenByDefault = false,
  onCancelReassign,
  agentPolicy
}) => {
  const authz = (0, _hooks.useAuthz)();
  const hasFleetAllPrivileges = authz.fleet.allAgents;
  const refreshAgent = (0, _hooks2.useAgentRefresh)();
  const [isReassignFlyoutOpen, setIsReassignFlyoutOpen] = (0, _react.useState)(assignFlyoutOpenByDefault);
  const [isUnenrollModalOpen, setIsUnenrollModalOpen] = (0, _react.useState)(false);
  const [isUpgradeModalOpen, setIsUpgradeModalOpen] = (0, _react.useState)(false);
  const [isRequestDiagnosticsModalOpen, setIsRequestDiagnosticsModalOpen] = (0, _react.useState)(false);
  const [isAgentDetailsJsonFlyoutOpen, setIsAgentDetailsJsonFlyoutOpen] = (0, _react.useState)(false);
  const isUnenrolling = agent.status === 'unenrolling';
  const isAgentUpdating = (0, _agent_status.isStuckInUpdating)(agent);
  const [isContextMenuOpen, setIsContextMenuOpen] = (0, _react.useState)(false);
  const onContextMenuChange = (0, _react.useCallback)(open => {
    setIsContextMenuOpen(open);
  }, [setIsContextMenuOpen]);
  const hasFleetServer = agentPolicy && (0, _services2.policyHasFleetServer)(agentPolicy);
  const {
    diagnosticFileUploadEnabled
  } = _services2.ExperimentalFeaturesService.get();
  const onClose = (0, _react.useMemo)(() => {
    if (onCancelReassign) {
      return onCancelReassign;
    } else {
      return () => setIsReassignFlyoutOpen(false);
    }
  }, [onCancelReassign, setIsReassignFlyoutOpen]);
  const menuItems = [...(hasFleetAllPrivileges && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed) ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "pencil",
    onClick: () => {
      setIsReassignFlyoutOpen(true);
    },
    disabled: !agent.active && !agentPolicy || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
    key: "reassignPolicy"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.reassignActionText",
    defaultMessage: "Assign to new policy"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "refresh",
    disabled: !(0, _services2.isAgentUpgradeable)(agent),
    onClick: () => {
      setIsUpgradeModalOpen(true);
    },
    key: "upgradeAgent",
    "data-test-subj": "upgradeBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.upgradeOneButton",
    defaultMessage: "Upgrade agent"
  }))] : []), ...(hasFleetAllPrivileges && isAgentUpdating ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "refresh",
    onClick: () => {
      setIsUpgradeModalOpen(true);
    },
    key: "restartUpgradeAgent",
    "data-test-subj": "restartUpgradeBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.restartUpgradeOneButton",
    defaultMessage: "Restart upgrade"
  }))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "inspect",
    onClick: () => {
      setIsContextMenuOpen(false);
      setIsAgentDetailsJsonFlyoutOpen(!isAgentDetailsJsonFlyoutOpen);
    },
    key: "agentDetailsJson",
    "data-test-subj": "viewAgentDetailsJsonBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.viewAgentDetailsJsonText",
    defaultMessage: "View agent JSON"
  })), ...(authz.fleet.readAgents && diagnosticFileUploadEnabled ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "download",
    disabled: !(0, _services.isAgentRequestDiagnosticsSupported)(agent),
    onClick: () => {
      setIsRequestDiagnosticsModalOpen(true);
    },
    "data-test-subj": "requestAgentDiagnosticsBtn",
    key: "requestDiagnostics"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.diagnosticsOneButton",
    defaultMessage: "Request diagnostics .zip"
  }))] : []), ...(hasFleetAllPrivileges && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed) ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "trash",
    disabled: !hasFleetAllPrivileges || !agent.active,
    onClick: () => {
      setIsUnenrollModalOpen(true);
    },
    key: "unenrollAgent"
  }, isUnenrolling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.forceUnenrollOneButton",
    defaultMessage: "Force unenroll"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.unenrollOneButton",
    defaultMessage: "Unenroll agent"
  }))] : [])];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isReassignFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentReassignAgentPolicyModal, {
    agents: [agent],
    onClose: onClose
  })), isUnenrollModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentUnenrollAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUnenrollModalOpen(false);
      refreshAgent();
    },
    useForceUnenroll: isUnenrolling,
    hasFleetServer: hasFleetServer
  })), isUpgradeModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentUpgradeAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUpgradeModalOpen(false);
      refreshAgent();
    },
    isUpdating: isAgentUpdating
  })), isRequestDiagnosticsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsRequestDiagnosticsModalOpen(false);
    }
  })), isAgentDetailsJsonFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_details_json_flyout.AgentDetailsJsonFlyout, {
    agent: agent,
    onClose: () => setIsAgentDetailsJsonFlyoutOpen(false)
  })), /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
    isOpen: isContextMenuOpen,
    onChange: onContextMenuChange,
    button: {
      props: {
        iconType: 'arrowDown',
        iconSide: 'right',
        color: 'primary'
      },
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentDetails.actionsButton",
        defaultMessage: "Actions"
      })
    },
    items: menuItems
  }));
});