"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupTechnologySelector = exports.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _types = require("../../../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = exports.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = 'setup-technology-selector';
const SetupTechnologySelector = ({
  disabled,
  setupTechnology,
  onSetupTechnologyChange
}) => {
  const options = [{
    value: _types.SetupTechnology.AGENTLESS,
    inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.agentlessInputDisplay",
      defaultMessage: "Agentless"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: "Beta",
      size: "s",
      tooltipContent: "This module is not yet GA. Please help us by reporting any bugs."
    })),
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.agentlessDrowpownDisplay",
      defaultMessage: "Agentless"
    })), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: "Beta",
      size: "s",
      tooltipContent: "This module is not GA. Please help us by reporting any bugs."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.agentlessDrowpownDescription",
      defaultMessage: "Set up the integration without an agent"
    }))))
  }, {
    value: _types.SetupTechnology.AGENT_BASED,
    inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.agentbasedInputDisplay",
      defaultMessage: "Agent-based"
    }),
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.agentbasedDrowpownDisplay",
      defaultMessage: "Agent-based"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.agentbasedDrowpownDescription",
      defaultMessage: "Set up the integration with an agent"
    }))))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.setupTechnologyLabel",
      defaultMessage: "Setup technology"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled,
    options: options,
    valueOfSelected: setupTechnology,
    placeholder: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.setupTechnologyPlaceholder",
      defaultMessage: "Select the setup technology"
    }),
    onChange: onSetupTechnologyChange,
    itemLayoutAlign: "top",
    hasDividers: true,
    fullWidth: true,
    "data-test-subj": SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ
  })));
};
exports.SetupTechnologySelector = SetupTechnologySelector;