"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfiguredSettings = ConfiguredSettings;
exports.settingComponentRegistry = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _zod = require("@kbn/zod");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _settings_field_group = require("./settings_field_group");
var _settings_field_wrapper = require("./settings_field_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const settingComponentRegistry = exports.settingComponentRegistry = new Map();
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodObject, ({
  disabled,
  ...settingsConfig
}) => /*#__PURE__*/_react.default.createElement(_settings_field_group.SettingsFieldGroup, {
  settingsConfig: settingsConfig,
  disabled: disabled
}));
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodNumber, ({
  disabled,
  ...settingsConfig
}) => {
  return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
    settingsConfig: settingsConfig,
    typeName: _zod.ZodFirstPartyTypeKind.ZodNumber,
    renderItem: ({
      fieldKey,
      fieldValue,
      handleChange,
      isInvalid,
      coercedSchema
    }) => {
      var _coercedSchema$minVal, _coercedSchema$maxVal;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        fullWidth: true,
        disabled: disabled,
        "data-test-subj": fieldKey,
        value: fieldValue,
        onChange: handleChange,
        isInvalid: isInvalid,
        min: (_coercedSchema$minVal = coercedSchema.minValue) !== null && _coercedSchema$minVal !== void 0 ? _coercedSchema$minVal : undefined,
        max: (_coercedSchema$maxVal = coercedSchema.maxValue) !== null && _coercedSchema$maxVal !== void 0 ? _coercedSchema$maxVal : undefined
      });
    }
  });
});
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodString, ({
  disabled,
  ...settingsConfig
}) => {
  return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
    settingsConfig: settingsConfig,
    typeName: _zod.ZodFirstPartyTypeKind.ZodString,
    renderItem: ({
      fieldKey,
      fieldValue,
      handleChange,
      isInvalid
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      disabled: disabled,
      "data-test-subj": fieldKey,
      value: fieldValue,
      onChange: handleChange,
      isInvalid: isInvalid
    })
  });
});
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodEnum, ({
  disabled,
  ...settingsConfig
}) => {
  return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
    disabled: disabled,
    settingsConfig: settingsConfig,
    typeName: _zod.ZodFirstPartyTypeKind.ZodString,
    renderItem: ({
      fieldKey,
      fieldValue,
      handleChange
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": fieldKey,
      value: fieldValue,
      fullWidth: true,
      disabled: disabled,
      onChange: handleChange,
      options: settingsConfig.schema._def.innerType._def.values.map(value => ({
        text: value,
        value
      }))
    })
  });
});
function ConfiguredSettings({
  configuredSettings,
  disabled
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, configuredSettings.filter(configuredSetting => !configuredSetting.hidden).map(configuredSetting => {
    const Component = settingComponentRegistry.get((0, _settings_field_wrapper.getInnerType)(configuredSetting.schema));
    if (!Component) {
      throw new Error(`Unknown setting type: ${configuredSetting.schema._type}}`);
    }
    return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({
      key: configuredSetting.name
    }, configuredSetting, {
      disabled: disabled
    }));
  }));
}