"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllowedOutputTypeForPolicy = getAllowedOutputTypeForPolicy;
exports.getAllowedOutputTypesForIntegration = getAllowedOutputTypesForIntegration;
exports.getDefaultPresetForEsOutput = getDefaultPresetForEsOutput;
exports.outputTypeSupportPresets = outputTypeSupportPresets;
exports.outputYmlIncludesReservedPerformanceKey = outputYmlIncludesReservedPerformanceKey;
var _lodash = require("lodash");
var _std = require("@kbn/std");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sameClusterRestrictedPackages = [_constants.FLEET_SERVER_PACKAGE, _constants.FLEET_SYNTHETICS_PACKAGE, _constants.FLEET_APM_PACKAGE];

/**
 * Return allowed output type for a given agent policy,
 * Fleet Server and APM cannot use anything else than same cluster ES
 */
function getAllowedOutputTypeForPolicy(agentPolicy) {
  const isRestrictedToSameClusterES = agentPolicy.package_policies && agentPolicy.package_policies.some(p => {
    var _p$package, _p$package2;
    return ((_p$package = p.package) === null || _p$package === void 0 ? void 0 : _p$package.name) && sameClusterRestrictedPackages.includes((_p$package2 = p.package) === null || _p$package2 === void 0 ? void 0 : _p$package2.name);
  });
  if (isRestrictedToSameClusterES) {
    return [_constants.outputType.Elasticsearch];
  }
  return Object.values(_constants.outputType);
}
function getAllowedOutputTypesForIntegration(packageName) {
  const isRestrictedToSameClusterES = sameClusterRestrictedPackages.includes(packageName);
  if (isRestrictedToSameClusterES) {
    return [_constants.outputType.Elasticsearch];
  }
  return Object.values(_constants.outputType);
}
function outputYmlIncludesReservedPerformanceKey(configYml,
// Dependency injection for `safeLoad` prevents bundle size issues 🤷‍♀️
safeLoad) {
  if (!configYml || configYml === '') {
    return false;
  }
  const parsedYml = safeLoad(configYml);
  if (!(0, _lodash.isObject)(parsedYml)) {
    if (typeof parsedYml === 'string') {
      return _constants.RESERVED_CONFIG_YML_KEYS.some(key => parsedYml.includes(key));
    }
    return false;
  }
  const flattenedYml = (0, _lodash.isObject)(parsedYml) ? (0, _std.getFlattenedObject)(parsedYml) : {};
  return _constants.RESERVED_CONFIG_YML_KEYS.some(key => Object.keys(flattenedYml).includes(key));
}
function getDefaultPresetForEsOutput(configYaml, safeLoad) {
  if (outputYmlIncludesReservedPerformanceKey(configYaml, safeLoad)) {
    return 'custom';
  }
  return 'balanced';
}
function outputTypeSupportPresets(type) {
  return _constants.OUTPUT_TYPES_WITH_PRESET_SUPPORT.includes(type);
}