"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isOnlyAgentlessPolicyTemplate = exports.isOnlyAgentlessIntegration = exports.isAgentlessIntegration = exports.getAgentlessAgentPolicyNameFromPackagePolicyName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAgentlessIntegration = packageInfo => {
  if (packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates && (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates.length) > 0 && !!(packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates.find(policyTemplate => {
    var _policyTemplate$deplo;
    return (policyTemplate === null || policyTemplate === void 0 ? void 0 : (_policyTemplate$deplo = policyTemplate.deployment_modes) === null || _policyTemplate$deplo === void 0 ? void 0 : _policyTemplate$deplo.agentless.enabled) === true;
  }))) {
    return true;
  }
  return false;
};
exports.isAgentlessIntegration = isAgentlessIntegration;
const getAgentlessAgentPolicyNameFromPackagePolicyName = packagePolicyName => {
  return `Agentless policy for ${packagePolicyName}`;
};
exports.getAgentlessAgentPolicyNameFromPackagePolicyName = getAgentlessAgentPolicyNameFromPackagePolicyName;
const isOnlyAgentlessIntegration = packageInfo => {
  if (packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates && (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates.length) > 0 && packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates.every(policyTemplate => isOnlyAgentlessPolicyTemplate(policyTemplate))) {
    return true;
  }
  return false;
};
exports.isOnlyAgentlessIntegration = isOnlyAgentlessIntegration;
const isOnlyAgentlessPolicyTemplate = policyTemplate => {
  return Boolean(policyTemplate.deployment_modes && policyTemplate.deployment_modes.agentless.enabled === true && (!policyTemplate.deployment_modes.default || policyTemplate.deployment_modes.default.enabled === false));
};
exports.isOnlyAgentlessPolicyTemplate = isOnlyAgentlessPolicyTemplate;