"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_UPDATING_TIMEOUT_HOURS = void 0;
exports.buildKueryForErrorAgents = buildKueryForErrorAgents;
exports.buildKueryForInactiveAgents = buildKueryForInactiveAgents;
exports.buildKueryForOfflineAgents = buildKueryForOfflineAgents;
exports.buildKueryForOnlineAgents = buildKueryForOnlineAgents;
exports.buildKueryForUnenrolledAgents = buildKueryForUnenrolledAgents;
exports.buildKueryForUpdatingAgents = buildKueryForUpdatingAgents;
exports.getPreviousAgentStatusForOfflineAgents = getPreviousAgentStatusForOfflineAgents;
exports.isAgentInFailedUpgradeState = isAgentInFailedUpgradeState;
exports.isStuckInUpdating = isStuckInUpdating;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPreviousAgentStatusForOfflineAgents(agent) {
  var _agent$last_checkin_s, _agent$last_checkin_s2;
  if (agent.unenrollment_started_at && !agent.unenrolled_at) {
    return 'unenrolling';
  }
  if (((_agent$last_checkin_s = agent.last_checkin_status) === null || _agent$last_checkin_s === void 0 ? void 0 : _agent$last_checkin_s.toLowerCase()) === 'error') {
    return 'error';
  }
  if (((_agent$last_checkin_s2 = agent.last_checkin_status) === null || _agent$last_checkin_s2 === void 0 ? void 0 : _agent$last_checkin_s2.toLowerCase()) === 'degraded') {
    return 'degraded';
  }
  const policyRevision = 'policy_revision' in agent ? agent.policy_revision : 'policy_revision_idx' in agent ? agent.policy_revision_idx : undefined;
  if (!policyRevision || agent.upgrade_started_at && !agent.upgraded_at) {
    return 'updating';
  }
}
function buildKueryForUnenrolledAgents() {
  return 'status:unenrolled';
}
function buildKueryForOnlineAgents() {
  return 'status:online';
}
function buildKueryForErrorAgents() {
  return '(status:error or status:degraded)';
}
function buildKueryForOfflineAgents() {
  return 'status:offline';
}
function buildKueryForUpdatingAgents() {
  return '(status:updating or status:unenrolling or status:enrolling)';
}
function buildKueryForInactiveAgents() {
  return 'status:inactive';
}
const AGENT_UPDATING_TIMEOUT_HOURS = exports.AGENT_UPDATING_TIMEOUT_HOURS = 2;
function isStuckInUpdating(agent) {
  return agent.status !== 'offline' && agent.active && isAgentInFailedUpgradeState(agent) || agent.status === 'updating' && !!agent.upgrade_started_at && !agent.upgraded_at && Date.now() - Date.parse(agent.upgrade_started_at) > AGENT_UPDATING_TIMEOUT_HOURS * 60 * 60 * 1000;
}
function isAgentInFailedUpgradeState(agent) {
  var _agent$upgrade_detail;
  return ((_agent$upgrade_detail = agent.upgrade_details) === null || _agent$upgrade_detail === void 0 ? void 0 : _agent$upgrade_detail.state) === 'UPG_FAILED';
}