"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateAuthz = void 0;
exports.calculateEndpointExceptionsPrivilegesFromCapabilities = calculateEndpointExceptionsPrivilegesFromCapabilities;
exports.calculateEndpointExceptionsPrivilegesFromKibanaPrivileges = calculateEndpointExceptionsPrivilegesFromKibanaPrivileges;
exports.calculatePackagePrivilegesFromCapabilities = calculatePackagePrivilegesFromCapabilities;
exports.calculatePackagePrivilegesFromKibanaPrivileges = calculatePackagePrivilegesFromKibanaPrivileges;
exports.getAuthorizationFromPrivileges = getAuthorizationFromPrivileges;
var _plugin = require("./constants/plugin");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateAuthz = ({
  fleet,
  integrations,
  subfeatureEnabled
}) => {
  var _fleet$agents, _fleet$agentPolicies, _fleet$settings, _ref, _fleet$agentPolicies2, _ref2, _fleet$agentPolicies3, _ref3, _fleet$agentPolicies4, _ref4, _fleet$agentPolicies5, _ref5, _fleet$agents2, _fleet$agents3, _fleet$agents$all, _fleet$agents4, _ref6, _fleet$settings2, _fleet$settings3, _fleet$settings$all, _fleet$settings4, _fleet$agentPolicies$, _fleet$agentPolicies6, _fleet$agents$all2, _fleet$agents5, _ref7, _fleet$agents6, _fleet$agentPolicies7, _fleet$settings5, _fleet$agents7, _fleet$agentPolicies8, _fleet$settings6, _ref8, _fleet$agents8, _ref9, _fleet$agentPolicies9, _ref10, _fleet$agents9, _ref11;
  // When subfeatures are enabled, treat fleet.all as combination of all subfeatures
  const hasFleetAll = subfeatureEnabled ? !!((_fleet$agents = fleet.agents) !== null && _fleet$agents !== void 0 && _fleet$agents.all && (_fleet$agentPolicies = fleet.agentPolicies) !== null && _fleet$agentPolicies !== void 0 && _fleet$agentPolicies.all && (_fleet$settings = fleet.settings) !== null && _fleet$settings !== void 0 && _fleet$settings.all) : fleet.all;
  const writeIntegrationPolicies = subfeatureEnabled ? (_ref = ((_fleet$agentPolicies2 = fleet.agentPolicies) === null || _fleet$agentPolicies2 === void 0 ? void 0 : _fleet$agentPolicies2.all) && integrations.all) !== null && _ref !== void 0 ? _ref : false : ((_ref2 = fleet.all || ((_fleet$agentPolicies3 = fleet.agentPolicies) === null || _fleet$agentPolicies3 === void 0 ? void 0 : _fleet$agentPolicies3.all)) !== null && _ref2 !== void 0 ? _ref2 : false) && integrations.all;
  const readIntegrationPolicies = subfeatureEnabled ? (_ref3 = ((_fleet$agentPolicies4 = fleet.agentPolicies) === null || _fleet$agentPolicies4 === void 0 ? void 0 : _fleet$agentPolicies4.read) && (integrations.all || integrations.read)) !== null && _ref3 !== void 0 ? _ref3 : false : ((_ref4 = fleet.all || fleet.read || ((_fleet$agentPolicies5 = fleet.agentPolicies) === null || _fleet$agentPolicies5 === void 0 ? void 0 : _fleet$agentPolicies5.read)) !== null && _ref4 !== void 0 ? _ref4 : false) && (integrations.all || integrations.read);

  // TODO remove fallback when the feature flag is removed
  const fleetAuthz = subfeatureEnabled ? {
    all: hasFleetAll && (integrations.all || integrations.read),
    readAgents: (_ref5 = ((_fleet$agents2 = fleet.agents) === null || _fleet$agents2 === void 0 ? void 0 : _fleet$agents2.read) || ((_fleet$agents3 = fleet.agents) === null || _fleet$agents3 === void 0 ? void 0 : _fleet$agents3.all)) !== null && _ref5 !== void 0 ? _ref5 : false,
    allAgents: (_fleet$agents$all = (_fleet$agents4 = fleet.agents) === null || _fleet$agents4 === void 0 ? void 0 : _fleet$agents4.all) !== null && _fleet$agents$all !== void 0 ? _fleet$agents$all : false,
    readSettings: (_ref6 = ((_fleet$settings2 = fleet.settings) === null || _fleet$settings2 === void 0 ? void 0 : _fleet$settings2.read) || ((_fleet$settings3 = fleet.settings) === null || _fleet$settings3 === void 0 ? void 0 : _fleet$settings3.all)) !== null && _ref6 !== void 0 ? _ref6 : false,
    allSettings: (_fleet$settings$all = (_fleet$settings4 = fleet.settings) === null || _fleet$settings4 === void 0 ? void 0 : _fleet$settings4.all) !== null && _fleet$settings$all !== void 0 ? _fleet$settings$all : false,
    allAgentPolicies: (_fleet$agentPolicies$ = (_fleet$agentPolicies6 = fleet.agentPolicies) === null || _fleet$agentPolicies6 === void 0 ? void 0 : _fleet$agentPolicies6.all) !== null && _fleet$agentPolicies$ !== void 0 ? _fleet$agentPolicies$ : false,
    addAgents: (_fleet$agents$all2 = (_fleet$agents5 = fleet.agents) === null || _fleet$agents5 === void 0 ? void 0 : _fleet$agents5.all) !== null && _fleet$agents$all2 !== void 0 ? _fleet$agents$all2 : false,
    addFleetServers: (_ref7 = ((_fleet$agents6 = fleet.agents) === null || _fleet$agents6 === void 0 ? void 0 : _fleet$agents6.all) && ((_fleet$agentPolicies7 = fleet.agentPolicies) === null || _fleet$agentPolicies7 === void 0 ? void 0 : _fleet$agentPolicies7.all) && ((_fleet$settings5 = fleet.settings) === null || _fleet$settings5 === void 0 ? void 0 : _fleet$settings5.all)) !== null && _ref7 !== void 0 ? _ref7 : false,
    // Setup is needed to access the Fleet UI
    setup: hasFleetAll || fleet.read || ((_fleet$agents7 = fleet.agents) === null || _fleet$agents7 === void 0 ? void 0 : _fleet$agents7.read) || ((_fleet$agentPolicies8 = fleet.agentPolicies) === null || _fleet$agentPolicies8 === void 0 ? void 0 : _fleet$agentPolicies8.read) || ((_fleet$settings6 = fleet.settings) === null || _fleet$settings6 === void 0 ? void 0 : _fleet$settings6.read) || fleet.setup,
    // These are currently used by Fleet Server setup
    readEnrollmentTokens: (_ref8 = fleet.setup || ((_fleet$agents8 = fleet.agents) === null || _fleet$agents8 === void 0 ? void 0 : _fleet$agents8.all)) !== null && _ref8 !== void 0 ? _ref8 : false,
    readAgentPolicies: (_ref9 = fleet.setup || ((_fleet$agentPolicies9 = fleet.agentPolicies) === null || _fleet$agentPolicies9 === void 0 ? void 0 : _fleet$agentPolicies9.read)) !== null && _ref9 !== void 0 ? _ref9 : false
  } : {
    all: fleet.all && (integrations.all || integrations.read),
    readAgents: fleet.all && (integrations.all || integrations.read),
    allAgents: fleet.all && (integrations.all || integrations.read),
    readSettings: fleet.all && (integrations.all || integrations.read),
    allSettings: fleet.all && (integrations.all || integrations.read),
    allAgentPolicies: fleet.all && (integrations.all || integrations.read),
    addAgents: fleet.all && (integrations.all || integrations.read),
    addFleetServers: fleet.all && (integrations.all || integrations.read),
    // These are currently used by Fleet Server setup
    setup: fleet.all || fleet.setup,
    readEnrollmentTokens: (_ref10 = fleet.all || fleet.setup || ((_fleet$agents9 = fleet.agents) === null || _fleet$agents9 === void 0 ? void 0 : _fleet$agents9.all)) !== null && _ref10 !== void 0 ? _ref10 : false,
    readAgentPolicies: (_ref11 = fleet.all || fleet.setup) !== null && _ref11 !== void 0 ? _ref11 : false
  };
  return {
    fleet: fleetAuthz,
    integrations: {
      readPackageInfo: hasFleetAll || fleet.setup || integrations.all || integrations.read,
      readInstalledPackages: integrations.all || integrations.read,
      installPackages: writeIntegrationPolicies && integrations.all,
      upgradePackages: writeIntegrationPolicies && integrations.all,
      removePackages: writeIntegrationPolicies && integrations.all,
      uploadPackages: writeIntegrationPolicies && integrations.all,
      readPackageSettings: integrations.read,
      writePackageSettings: writeIntegrationPolicies && integrations.all,
      readIntegrationPolicies,
      writeIntegrationPolicies
    }
  };
};
exports.calculateAuthz = calculateAuthz;
function calculatePackagePrivilegesFromCapabilities(capabilities) {
  if (!capabilities) {
    return {};
  }
  const endpointActions = Object.entries(_constants.ENDPOINT_PRIVILEGES).reduce((acc, [privilege, {
    privilegeName
  }]) => {
    acc[privilege] = {
      executePackageAction: capabilities.siem && capabilities.siem[privilegeName] || false
    };
    return acc;
  }, {});
  const transformActions = Object.keys(capabilities.transform).reduce((acc, privilegeName) => {
    acc[privilegeName] = {
      executePackageAction: capabilities.transform[privilegeName] || false
    };
    return acc;
  }, {});
  return {
    endpoint: {
      actions: endpointActions
    },
    transform: {
      actions: transformActions
    }
  };
}
function calculateEndpointExceptionsPrivilegesFromCapabilities(capabilities) {
  if (!capabilities || !capabilities.siem) {
    return;
  }
  const endpointExceptionsActions = Object.keys(_constants.ENDPOINT_EXCEPTIONS_PRIVILEGES).reduce((acc, privilegeName) => {
    acc[privilegeName] = capabilities.siem[privilegeName] || false;
    return acc;
  }, {});
  return {
    actions: endpointExceptionsActions
  };
}
function getAuthorizationFromPrivileges({
  kibanaPrivileges,
  searchPrivilege = '',
  prefix = ''
}) {
  const privilege = kibanaPrivileges.find(p => {
    if (prefix.length && searchPrivilege.length) {
      return p.privilege.endsWith(`${prefix}${searchPrivilege}`);
    } else if (prefix.length) {
      return p.privilege.endsWith(`${prefix}`);
    } else if (searchPrivilege.length) {
      return p.privilege.endsWith(`${searchPrivilege}`);
    }
    return false;
  });
  return !!(privilege !== null && privilege !== void 0 && privilege.authorized);
}
function calculatePackagePrivilegesFromKibanaPrivileges(kibanaPrivileges) {
  if (!kibanaPrivileges || !kibanaPrivileges.length) {
    return {};
  }
  const endpointActions = Object.entries(_constants.ENDPOINT_PRIVILEGES).reduce((acc, [privilege, {
    appId,
    privilegeSplit,
    privilegeName
  }]) => {
    const kibanaPrivilege = getAuthorizationFromPrivileges({
      kibanaPrivileges,
      prefix: `${appId}${privilegeSplit}`,
      searchPrivilege: privilegeName
    });
    acc[privilege] = {
      executePackageAction: kibanaPrivilege
    };
    return acc;
  }, {});
  const hasTransformAdmin = getAuthorizationFromPrivileges({
    kibanaPrivileges,
    prefix: `${_plugin.TRANSFORM_PLUGIN_ID}-`,
    searchPrivilege: `admin`
  });
  const transformActions = {
    canCreateTransform: {
      executePackageAction: hasTransformAdmin
    },
    canDeleteTransform: {
      executePackageAction: hasTransformAdmin
    },
    canStartStopTransform: {
      executePackageAction: hasTransformAdmin
    },
    canGetTransform: {
      executePackageAction: getAuthorizationFromPrivileges({
        kibanaPrivileges,
        prefix: `${_plugin.TRANSFORM_PLUGIN_ID}-`,
        searchPrivilege: `read`
      })
    }
  };
  return {
    endpoint: {
      actions: endpointActions
    },
    transform: {
      actions: transformActions
    }
  };
}
function calculateEndpointExceptionsPrivilegesFromKibanaPrivileges(kibanaPrivileges) {
  if (!kibanaPrivileges || !kibanaPrivileges.length) {
    return;
  }
  const endpointExceptionsActions = Object.entries(_constants.ENDPOINT_EXCEPTIONS_PRIVILEGES).reduce((acc, [privilege, {
    appId,
    privilegeSplit,
    privilegeName
  }]) => {
    acc[privilege] = getAuthorizationFromPrivileges({
      kibanaPrivileges,
      searchPrivilege: privilegeName
    });
    return acc;
  }, {});
  return {
    actions: endpointExceptionsActions
  };
}