"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.register = register;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../common/constants");
var _api_routes = require("./api_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const method = 'delete';
const rt = {
  body: _configSchema.schema.object({
    ids: _configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1,
      maxSize: 100
    })
  })
};
const handler = async ({
  files
}, req, res) => {
  const fileService = (await files).fileService.asCurrentUser();
  const {
    body: {
      ids
    }
  } = req;
  const succeeded = [];
  const failed = [];
  for (const id of ids) {
    try {
      await fileService.delete({
        id
      });
      succeeded.push(id);
    } catch (e) {
      failed.push([id, e.message]);
    }
  }
  const body = {
    succeeded,
    failed: failed.length ? failed : undefined
  };
  return res.ok({
    body
  });
};
function register(router) {
  router[method]({
    path: _api_routes.FILES_API_ROUTES.bulkDelete,
    validate: {
      ...rt
    },
    options: {
      tags: [`access:${_constants.FILES_MANAGE_PRIVILEGE}`]
    }
  }, handler);
}