"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileFlyout = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _sharedUxFileImage = require("@kbn/shared-ux-file-image");
var _react = _interopRequireDefault(require("react"));
var _i18n_texts = require("../i18n_texts");
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FileFlyout = ({
  onClose,
  file
}) => {
  var _file$extension$toUpp, _file$extension, _file$mimeType, _file$mimeType2, _file$alt;
  const {
    filesClient
  } = (0, _context.useFilesManagementContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, file.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    listItems: [{
      title: _i18n_texts.i18nTexts.filesFlyoutStatus,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: file.status === 'READY' ? 'success' : file.status === 'AWAITING_UPLOAD' || file.status === 'UPLOADING' ? 'primary' : 'warning'
      }, _i18n_texts.i18nTexts.filesStatus[file.status])
    }, {
      title: _i18n_texts.i18nTexts.filesFlyoutSize,
      description: (0, _numeral.default)(file.size).format('0[.]0 b')
    }, {
      title: _i18n_texts.i18nTexts.filesFlyoutExtension,
      description: (_file$extension$toUpp = (_file$extension = file.extension) === null || _file$extension === void 0 ? void 0 : _file$extension.toUpperCase()) !== null && _file$extension$toUpp !== void 0 ? _file$extension$toUpp : ''
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    listItems: [{
      title: _i18n_texts.i18nTexts.filesFlyoutMimeType,
      description: (_file$mimeType = file.mimeType) !== null && _file$mimeType !== void 0 ? _file$mimeType : ''
    }, {
      title: _i18n_texts.i18nTexts.filesFlyoutCreated,
      description: file.created
    }, {
      title: _i18n_texts.i18nTexts.filesFlyoutUpdated,
      description: file.updated
    }]
  }))), ((_file$mimeType2 = file.mimeType) === null || _file$mimeType2 === void 0 ? void 0 : _file$mimeType2.startsWith('image/')) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n_texts.i18nTexts.filesFlyoutPreview)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxFileImage.FileImage, {
    size: "xl",
    alt: (_file$alt = file.alt) !== null && _file$alt !== void 0 ? _file$alt : '',
    src: filesClient.getDownloadHref(file)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: filesClient.getDownloadHref(file),
    iconType: "download"
  }, _i18n_texts.i18nTexts.filesFlyoutDownload))));
};
exports.FileFlyout = FileFlyout;