"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsMetadataClient = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldsMetadataClient {
  constructor(logger, ecsFieldsRepository, metadataFieldsRepository, integrationFieldsRepository) {
    this.logger = logger;
    this.ecsFieldsRepository = ecsFieldsRepository;
    this.metadataFieldsRepository = metadataFieldsRepository;
    this.integrationFieldsRepository = integrationFieldsRepository;
  }
  async getByName(fieldName, {
    integration,
    dataset
  } = {}) {
    this.logger.debug(`Retrieving field metadata for: ${fieldName}`);

    // 1. Try resolving from metadata-fields static metadata
    let field = this.metadataFieldsRepository.getByName(fieldName);

    // 2. Try resolving from ecs static metadata
    if (!field) {
      field = this.ecsFieldsRepository.getByName(fieldName);
    }

    // 2. Try searching for the fiels in the Elastic Package Registry
    if (!field) {
      field = await this.integrationFieldsRepository.getByName(fieldName, {
        integration,
        dataset
      });
    }
    return field;
  }
  async find({
    fieldNames,
    integration,
    dataset
  } = {}) {
    if (!fieldNames) {
      return _common.FieldsMetadataDictionary.create({
        ...this.metadataFieldsRepository.find().getFields(),
        ...this.ecsFieldsRepository.find().getFields()
      });
    }
    const fields = {};
    for (const fieldName of fieldNames) {
      const field = await this.getByName(fieldName, {
        integration,
        dataset
      });
      if (field) {
        fields[fieldName] = field;
      }
    }
    return _common.FieldsMetadataDictionary.create(fields);
  }
  static create({
    logger,
    ecsFieldsRepository,
    metadataFieldsRepository,
    integrationFieldsRepository
  }) {
    return new FieldsMetadataClient(logger, ecsFieldsRepository, metadataFieldsRepository, integrationFieldsRepository);
  }
}
exports.FieldsMetadataClient = FieldsMetadataClient;