"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initFindFieldsMetadataRoute = void 0;
var _runtime_types = require("../../../common/runtime_types");
var _fields_metadata = require("../../../common/fields_metadata");
var fieldsMetadataV1 = _interopRequireWildcard(require("../../../common/fields_metadata/v1"));
var _errors = require("../../services/fields_metadata/errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initFindFieldsMetadataRoute = ({
  router,
  getStartServices
}) => {
  router.versioned.get({
    access: 'internal',
    path: _fields_metadata.FIND_FIELDS_METADATA_URL
  }).addVersion({
    version: '1',
    validate: {
      request: {
        query: (0, _runtime_types.createValidationFunction)(fieldsMetadataV1.findFieldsMetadataRequestQueryRT)
      }
    }
  }, async (_requestContext, request, response) => {
    const {
      attributes,
      fieldNames,
      integration,
      dataset
    } = request.query;
    const [_core, _startDeps, startContract] = await getStartServices();
    const fieldsMetadataClient = startContract.getClient();
    try {
      const fieldsDictionary = await fieldsMetadataClient.find({
        fieldNames,
        integration,
        dataset
      });
      const responsePayload = {
        fields: {}
      };
      if (attributes) {
        responsePayload.fields = fieldsDictionary.pick(attributes);
      } else {
        responsePayload.fields = fieldsDictionary.toPlain();
      }
      return response.ok({
        body: fieldsMetadataV1.findFieldsMetadataResponsePayloadRT.encode(responsePayload)
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      if (error instanceof _errors.PackageNotFoundError) {
        return response.badRequest({
          body: {
            message: error.message
          }
        });
      }
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initFindFieldsMetadataRoute = initFindFieldsMetadataRoute;