"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsMetadataPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fields_metadata_server = require("./fields_metadata_server");
var _fields_metadata = require("./services/fields_metadata");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldsMetadataPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "libs", void 0);
    (0, _defineProperty2.default)(this, "fieldsMetadataService", void 0);
    this.logger = context.logger.get();
    this.fieldsMetadataService = new _fields_metadata.FieldsMetadataService(this.logger);
  }
  setup(core, plugins) {
    const fieldsMetadata = this.fieldsMetadataService.setup();
    this.libs = {
      getStartServices: () => core.getStartServices(),
      logger: this.logger,
      plugins,
      router: core.http.createRouter()
    };

    // Register server side APIs
    (0, _fields_metadata_server.initFieldsMetadataServer)(this.libs);
    return {
      registerIntegrationFieldsExtractor: fieldsMetadata.registerIntegrationFieldsExtractor,
      registerIntegrationListExtractor: fieldsMetadata.registerIntegrationListExtractor
    };
  }
  start(_core, _plugins) {
    const fieldsMetadata = this.fieldsMetadataService.start();
    return {
      getClient: fieldsMetadata.getClient
    };
  }
}
exports.FieldsMetadataPlugin = FieldsMetadataPlugin;