"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tagcloudRenderer = exports.strings = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/visualizations-plugin/public");
var _analytics = require("@kbn/analytics");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _common = require("../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const strings = exports.strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionTagcloud.renderer.tagcloud.displayName', {
    defaultMessage: 'Tag Cloud visualization'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionTagcloud.renderer.tagcloud.helpDescription', {
    defaultMessage: 'Render a tag cloud'
  })
};
const tagCloudVisClass = {
  height: '100%'
};
const TagCloudChart = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/tagcloud_component'))));
const tagcloudRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_NAME,
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const renderComplete = () => {
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, [`render_${visualizationType}_${_common.EXPRESSION_NAME}`]);
      }
      handlers.done();
    };
    const chartSizeEvent = {
      name: 'chartSize',
      data: {
        maxDimensions: {
          x: {
            value: 100,
            unit: 'percentage'
          },
          y: {
            value: 100,
            unit: 'percentage'
          }
        }
      }
    };
    handlers.event(chartSizeEvent);
    const palettesRegistry = await plugins.charts.palettes.getPalettes();
    let isDarkMode = false;
    plugins.charts.theme.darkModeEnabled$.subscribe(val => {
      isDarkMode = val.darkMode;
    }).unsubscribe();
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(_react2.ClassNames, null, ({
      css,
      cx
    }) => /*#__PURE__*/_react.default.createElement(_public.VisualizationContainer, {
      handlers: handlers
      // Class `tagCloudContainer` is generated by `@emotion/react` and passed as a defined class to `VisualizationContainer`.
      // It is used for rendering at `Canvas`.
      ,
      className: cx('tagCloudContainer', css(tagCloudVisClass)),
      renderComplete: renderComplete
    }, /*#__PURE__*/_react.default.createElement(TagCloudChart, (0, _extends2.default)({}, config, {
      palettesRegistry: palettesRegistry,
      renderComplete: renderComplete,
      fireEvent: handlers.event,
      syncColors: config.syncColors,
      overrides: config.overrides,
      isDarkMode: isDarkMode
    }))))), domNode);
  }
});
exports.tagcloudRenderer = tagcloudRenderer;