"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wheel = void 0;
var _shape_factory = require("../../reusable/shape_factory");
var _reusable = require("../../reusable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const Wheel = exports.Wheel = (0, _shape_factory.createShape)({
  viewBox: {
    minX: 0,
    minY: 0,
    width: 120,
    height: 120
  },
  shapeType: _reusable.SvgElementTypes.path,
  shapeProps: {
    d: 'M 60 0 A 60 60 0 1 1 60 120 A 60 60 0 1 1 60 0 Z'
  },
  textAttributes: {
    x: '60',
    y: '60',
    textAnchor: 'middle',
    dominantBaseline: 'central'
  }
});