"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepeatImageComponent = RepeatImageComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function loadImage(src) {
  return new Promise((resolve, reject) => {
    const img = new Image();
    img.onload = () => resolve(img);
    img.onerror = error => reject(error);
    img.src = src;
  });
}
async function loadImages(images) {
  const results = await Promise.allSettled([...images.map(loadImage)]);
  return results.map(loadedImage => loadedImage.status === 'rejected' ? null : loadedImage.value);
}
function setImageSize(img, size) {
  if (img.naturalHeight > img.naturalWidth) {
    img.height = size;
  } else {
    img.width = size;
  }
}
function createImageJSX(img) {
  if (!img) {
    return null;
  }
  const params = img.width > img.height ? {
    height: img.height
  } : {
    width: img.width
  };
  return /*#__PURE__*/_react.default.createElement("img", (0, _extends2.default)({
    src: img.src
  }, params, {
    alt: ""
  }));
}
function RepeatImageComponent({
  max,
  count,
  emptyImage: emptyImageSrc,
  image: imageSrc,
  size,
  onLoaded
}) {
  const [images, setImages] = (0, _react.useState)({
    image: null,
    emptyImage: null
  });
  (0, _react.useEffect)(() => {
    loadImages([imageSrc, emptyImageSrc]).then(result => {
      const [image, emptyImage] = result;
      setImages({
        image,
        emptyImage
      });
      onLoaded();
    });
  }, [imageSrc, emptyImageSrc, onLoaded]);
  const imagesToRender = [];
  const {
    image,
    emptyImage
  } = images;
  if (max && count > max) count = max;
  if (image) {
    setImageSize(image, size);
    const imgJSX = createImageJSX(image);
    (0, _lodash.times)(count, () => imagesToRender.push(imgJSX));
  }
  if (emptyImage) {
    setImageSize(emptyImage, size);
    const imgJSX = createImageJSX(emptyImage);
    (0, _lodash.times)(max - count, () => imagesToRender.push(imgJSX));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "repeatImage",
    style: {
      pointerEvents: 'none'
    }
  }, imagesToRender);
}