"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHelpersAsync = exports.UpdateESQLQueryAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ACTION_UPDATE_ESQL_QUERY = 'ACTION_UPDATE_ESQL_QUERY';
const getHelpersAsync = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('./update_esql_query_helpers')));
exports.getHelpersAsync = getHelpersAsync;
class UpdateESQLQueryAction {
  constructor(data) {
    (0, _defineProperty2.default)(this, "type", ACTION_UPDATE_ESQL_QUERY);
    (0, _defineProperty2.default)(this, "id", ACTION_UPDATE_ESQL_QUERY);
    (0, _defineProperty2.default)(this, "order", 50);
    this.data = data;
  }
  getDisplayName() {
    return _i18n.i18n.translate('esql.updateESQLQueryLabel', {
      defaultMessage: 'Update the ES|QL query in the editor'
    });
  }
  getIconType() {
    return 'filter';
  }
  async isCompatible() {
    const {
      isActionCompatible
    } = await getHelpersAsync();
    return isActionCompatible(this.data);
  }
  async execute({
    queryString
  }) {
    const {
      executeAction
    } = await getHelpersAsync();
    return executeAction({
      queryString,
      data: this.data
    });
  }
}
exports.UpdateESQLQueryAction = UpdateESQLQueryAction;