"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildQueryUntilPreviousCommand = buildQueryUntilPreviousCommand;
exports.getFieldsByTypeHelper = getFieldsByTypeHelper;
exports.getPolicyHelper = getPolicyHelper;
exports.getSourcesHelper = getSourcesHelper;
var _ecs_metadata_helper = require("../autocomplete/utils/ecs_metadata_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function buildQueryUntilPreviousCommand(ast, queryString) {
  const prevCommand = ast[Math.max(ast.length - 2, 0)];
  return prevCommand ? queryString.substring(0, prevCommand.location.max + 1) : queryString;
}
function getFieldsByTypeHelper(queryText, resourceRetriever) {
  const cacheFields = new Map();
  const getEcsMetadata = async () => {
    if (!(resourceRetriever !== null && resourceRetriever !== void 0 && resourceRetriever.getFieldsMetadata)) {
      return undefined;
    }
    const client = await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : resourceRetriever.getFieldsMetadata);
    if (client.find) {
      // Fetch full list of ECS field
      // This list should be cached already by fieldsMetadataClient
      const results = await client.find({
        attributes: ['type']
      });
      return results === null || results === void 0 ? void 0 : results.fields;
    }
  };
  const getFields = async () => {
    const metadata = await getEcsMetadata();
    if (!cacheFields.size && queryText) {
      var _resourceRetriever$ge;
      const fieldsOfType = await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge = resourceRetriever.getFieldsFor) === null || _resourceRetriever$ge === void 0 ? void 0 : _resourceRetriever$ge.call(resourceRetriever, {
        query: queryText
      }));
      const fieldsWithMetadata = (0, _ecs_metadata_helper.enrichFieldsWithECSInfo)(fieldsOfType || [], metadata);
      for (const field of fieldsWithMetadata || []) {
        cacheFields.set(field.name, field);
      }
    }
  };
  return {
    getFieldsByType: async (expectedType = 'any', ignored = []) => {
      var _Array$from;
      const types = Array.isArray(expectedType) ? expectedType : [expectedType];
      await getFields();
      return ((_Array$from = Array.from(cacheFields.values())) === null || _Array$from === void 0 ? void 0 : _Array$from.filter(({
        name,
        type
      }) => {
        const ts = Array.isArray(type) ? type : [type];
        return !ignored.includes(name) && ts.some(t => types[0] === 'any' || types.includes(t));
      })) || [];
    },
    getFieldsMap: async () => {
      await getFields();
      const cacheCopy = new Map();
      cacheFields.forEach((value, key) => cacheCopy.set(key, value));
      return cacheCopy;
    }
  };
}
function getPolicyHelper(resourceRetriever) {
  const getPolicies = async () => {
    var _resourceRetriever$ge2;
    return (await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge2 = resourceRetriever.getPolicies) === null || _resourceRetriever$ge2 === void 0 ? void 0 : _resourceRetriever$ge2.call(resourceRetriever))) || [];
  };
  return {
    getPolicies: async () => {
      const policies = await getPolicies();
      return policies;
    },
    getPolicyMetadata: async policyName => {
      const policies = await getPolicies();
      return policies.find(({
        name
      }) => name === policyName);
    }
  };
}
function getSourcesHelper(resourceRetriever) {
  return async () => {
    var _resourceRetriever$ge3;
    return (await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge3 = resourceRetriever.getSources) === null || _resourceRetriever$ge3 === void 0 ? void 0 : _resourceRetriever$ge3.call(resourceRetriever))) || [];
  };
}