"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ENRICH_MODES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ENRICH_MODES = exports.ENRICH_MODES = {
  name: 'ccq.mode',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqModeDoc', {
    defaultMessage: 'Cross-clusters query mode'
  }),
  prefix: '_',
  values: [{
    name: 'any',
    description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqAnyDoc', {
      defaultMessage: 'Enrich takes place on any cluster'
    })
  }, {
    name: 'coordinator',
    description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqCoordinatorDoc', {
      defaultMessage: 'Enrich takes place on the coordinating cluster receiving an ES|QL'
    })
  }, {
    name: 'remote',
    description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqRemoteDoc', {
      defaultMessage: 'Enrich takes place on the cluster hosting the target index.'
    })
  }]
};