"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scalarFunctionDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../shared/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * __AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.__
 *
 * @note This file is generated by the `generate_function_definitions.ts`
 * script. Do not edit it manually.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const absDefinition = {
  type: 'eval',
  name: 'abs',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.abs', {
    defaultMessage: 'Returns the absolute value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW number = -1.0 \n| EVAL abs_number = ABS(number)', 'FROM employees\n| KEEP first_name, last_name, height\n| EVAL abs_height = ABS(0.0 - height)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const acosDefinition = {
  type: 'eval',
  name: 'acos',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.acos', {
    defaultMessage: 'Returns the arccosine of `n` as an angle, expressed in radians.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=.9\n| EVAL acos=ACOS(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const asinDefinition = {
  type: 'eval',
  name: 'asin',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.asin', {
    defaultMessage: 'Returns the arcsine of the input\nnumeric expression as an angle, expressed in radians.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=.9\n| EVAL asin=ASIN(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const atanDefinition = {
  type: 'eval',
  name: 'atan',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.atan', {
    defaultMessage: 'Returns the arctangent of the input\nnumeric expression as an angle, expressed in radians.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=12.9\n| EVAL atan=ATAN(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const atan2Definition = {
  type: 'eval',
  name: 'atan2',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.atan2', {
    defaultMessage: 'The angle between the positive x-axis and the ray from the\norigin to the point (x , y) in the Cartesian plane, expressed in radians.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'y_coordinate',
      type: 'double',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'double',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'double',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'double',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'integer',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'integer',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'integer',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'integer',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'long',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'long',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'long',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'long',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'y_coordinate',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'x_coordinate',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW y=12.9, x=.6\n| EVAL atan2=ATAN2(y, x)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const categorizeDefinition = {
  type: 'eval',
  name: 'categorize',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.categorize', {
    defaultMessage: 'Categorizes text messages.'
  }),
  ignoreAsSuggestion: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'integer'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const cbrtDefinition = {
  type: 'eval',
  name: 'cbrt',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.cbrt', {
    defaultMessage: 'Returns the cube root of a number. The input can be any numeric value, the return value is always a double.\nCube roots of infinities are null.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW d = 1000.0\n| EVAL c = cbrt(d)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const ceilDefinition = {
  type: 'eval',
  name: 'ceil',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ceil', {
    defaultMessage: 'Round a number up to the nearest integer.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=1.8\n| EVAL a=CEIL(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const cidrMatchDefinition = {
  type: 'eval',
  name: 'cidr_match',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.cidr_match', {
    defaultMessage: 'Returns true if the provided IP is contained in one of the provided CIDR blocks.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'ip',
      type: 'ip',
      optional: false
    }, {
      name: 'blockX',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }, {
    params: [{
      name: 'ip',
      type: 'ip',
      optional: false
    }, {
      name: 'blockX',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 2
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM hosts \n| WHERE CIDR_MATCH(ip1, "127.0.0.2/32", "127.0.0.3/32") \n| KEEP card, host, ip0, ip1']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const coalesceDefinition = {
  type: 'eval',
  name: 'coalesce',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.coalesce', {
    defaultMessage: 'Returns the first of its arguments that is not null. If all arguments are null, it returns `null`.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'first',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'boolean',
      optional: false
    }, {
      name: 'rest',
      type: 'boolean',
      optional: true
    }],
    returnType: 'boolean',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'rest',
      type: 'cartesian_point',
      optional: true
    }],
    returnType: 'cartesian_point',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'rest',
      type: 'cartesian_shape',
      optional: true
    }],
    returnType: 'cartesian_shape',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'date',
      optional: false
    }, {
      name: 'rest',
      type: 'date',
      optional: true
    }],
    returnType: 'date',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'geo_point',
      optional: false
    }, {
      name: 'rest',
      type: 'geo_point',
      optional: true
    }],
    returnType: 'geo_point',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'rest',
      type: 'geo_shape',
      optional: true
    }],
    returnType: 'geo_shape',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'integer',
      optional: false
    }, {
      name: 'rest',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'ip',
      optional: false
    }, {
      name: 'rest',
      type: 'ip',
      optional: true
    }],
    returnType: 'ip',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'keyword',
      optional: false
    }, {
      name: 'rest',
      type: 'keyword',
      optional: true
    }],
    returnType: 'keyword',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'long',
      optional: false
    }],
    returnType: 'long',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'long',
      optional: false
    }, {
      name: 'rest',
      type: 'long',
      optional: true
    }],
    returnType: 'long',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'text',
      optional: false
    }],
    returnType: 'text',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'text',
      optional: false
    }, {
      name: 'rest',
      type: 'text',
      optional: true
    }],
    returnType: 'text',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'version',
      optional: false
    }, {
      name: 'rest',
      type: 'version',
      optional: true
    }],
    returnType: 'version',
    minParams: 1
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=null, b="b"\n| EVAL COALESCE(a, b)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const concatDefinition = {
  type: 'eval',
  name: 'concat',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.concat', {
    defaultMessage: 'Concatenates two or more strings.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string1',
      type: 'keyword',
      optional: false
    }, {
      name: 'string2',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword',
    minParams: 2
  }, {
    params: [{
      name: 'string1',
      type: 'keyword',
      optional: false
    }, {
      name: 'string2',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword',
    minParams: 2
  }, {
    params: [{
      name: 'string1',
      type: 'text',
      optional: false
    }, {
      name: 'string2',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword',
    minParams: 2
  }, {
    params: [{
      name: 'string1',
      type: 'text',
      optional: false
    }, {
      name: 'string2',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword',
    minParams: 2
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP first_name, last_name\n| EVAL fullname = CONCAT(first_name, " ", last_name)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const cosDefinition = {
  type: 'eval',
  name: 'cos',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.cos', {
    defaultMessage: 'Returns the cosine of an angle.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'angle',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=1.8 \n| EVAL cos=COS(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const coshDefinition = {
  type: 'eval',
  name: 'cosh',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.cosh', {
    defaultMessage: 'Returns the hyperbolic cosine of a number.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=1.8 \n| EVAL cosh=COSH(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateDiffDefinition = {
  type: 'eval',
  name: 'date_diff',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.date_diff', {
    defaultMessage: 'Subtracts the `startTimestamp` from the `endTimestamp` and returns the difference in multiples of `unit`.\nIf `startTimestamp` is later than the `endTimestamp`, negative values are returned.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'unit',
      type: 'keyword',
      optional: false,
      acceptedValues: ['year', 'years', 'yy', 'yyyy', 'quarter', 'quarters', 'qq', 'q', 'month', 'months', 'mm', 'm', 'dayofyear', 'dy', 'y', 'day', 'days', 'dd', 'd', 'week', 'weeks', 'wk', 'ww', 'weekday', 'weekdays', 'dw', 'hour', 'hours', 'hh', 'minute', 'minutes', 'mi', 'n', 'second', 'seconds', 'ss', 's', 'millisecond', 'milliseconds', 'ms', 'microsecond', 'microseconds', 'mcs', 'nanosecond', 'nanoseconds', 'ns'],
      literalSuggestions: ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond', 'microsecond', 'nanosecond']
    }, {
      name: 'startTimestamp',
      type: 'date',
      optional: false
    }, {
      name: 'endTimestamp',
      type: 'date',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'unit',
      type: 'text',
      optional: false
    }, {
      name: 'startTimestamp',
      type: 'date',
      optional: false
    }, {
      name: 'endTimestamp',
      type: 'date',
      optional: false
    }],
    returnType: 'integer'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW date1 = TO_DATETIME("2023-12-02T11:00:00.000Z"), date2 = TO_DATETIME("2023-12-02T11:00:00.001Z")\n| EVAL dd_ms = DATE_DIFF("microseconds", date1, date2)', 'ROW end_23="2023-12-31T23:59:59.999Z"::DATETIME,\n  start_24="2024-01-01T00:00:00.000Z"::DATETIME,\n    end_24="2024-12-31T23:59:59.999"::DATETIME\n| EVAL end23_to_start24=DATE_DIFF("year", end_23, start_24)\n| EVAL end23_to_end24=DATE_DIFF("year", end_23, end_24)\n| EVAL start_to_end_24=DATE_DIFF("year", start_24, end_24)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateExtractDefinition = {
  type: 'eval',
  name: 'date_extract',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.date_extract', {
    defaultMessage: 'Extracts parts of a date, like year, month, day, hour.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'datePart',
      type: 'keyword',
      optional: false,
      acceptedValues: ['ALIGNED_DAY_OF_WEEK_IN_MONTH', 'ALIGNED_DAY_OF_WEEK_IN_YEAR', 'ALIGNED_WEEK_OF_MONTH', 'ALIGNED_WEEK_OF_YEAR', 'AMPM_OF_DAY', 'CLOCK_HOUR_OF_AMPM', 'CLOCK_HOUR_OF_DAY', 'DAY_OF_MONTH', 'DAY_OF_WEEK', 'DAY_OF_YEAR', 'EPOCH_DAY', 'ERA', 'HOUR_OF_AMPM', 'HOUR_OF_DAY', 'INSTANT_SECONDS', 'MICRO_OF_DAY', 'MICRO_OF_SECOND', 'MILLI_OF_DAY', 'MILLI_OF_SECOND', 'MINUTE_OF_DAY', 'MINUTE_OF_HOUR', 'MONTH_OF_YEAR', 'NANO_OF_DAY', 'NANO_OF_SECOND', 'OFFSET_SECONDS', 'PROLEPTIC_MONTH', 'SECOND_OF_DAY', 'SECOND_OF_MINUTE', 'YEAR', 'YEAR_OF_ERA']
    }, {
      name: 'date',
      type: 'date',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'datePart',
      type: 'text',
      optional: false
    }, {
      name: 'date',
      type: 'date',
      optional: false
    }],
    returnType: 'long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW date = DATE_PARSE("yyyy-MM-dd", "2022-05-06")\n| EVAL year = DATE_EXTRACT("year", date)', 'FROM sample_data\n| WHERE DATE_EXTRACT("hour_of_day", @timestamp) < 9 AND DATE_EXTRACT("hour_of_day", @timestamp) >= 17']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateFormatDefinition = {
  type: 'eval',
  name: 'date_format',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.date_format', {
    defaultMessage: 'Returns a string representation of a date, in the provided format.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'dateFormat',
      type: 'keyword',
      optional: true
    }, {
      name: 'date',
      type: 'date',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'dateFormat',
      type: 'text',
      optional: true
    }, {
      name: 'date',
      type: 'date',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP first_name, last_name, hire_date\n| EVAL hired = DATE_FORMAT("yyyy-MM-dd", hire_date)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateParseDefinition = {
  type: 'eval',
  name: 'date_parse',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.date_parse', {
    defaultMessage: 'Returns a date by parsing the second argument using the format specified in the first argument.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'datePattern',
      type: 'keyword',
      optional: true
    }, {
      name: 'dateString',
      type: 'keyword',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'datePattern',
      type: 'keyword',
      optional: true
    }, {
      name: 'dateString',
      type: 'text',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'datePattern',
      type: 'text',
      optional: true
    }, {
      name: 'dateString',
      type: 'keyword',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'datePattern',
      type: 'text',
      optional: true
    }, {
      name: 'dateString',
      type: 'text',
      optional: false
    }],
    returnType: 'date'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW date_string = "2022-05-06"\n| EVAL date = DATE_PARSE("yyyy-MM-dd", date_string)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const dateTruncDefinition = {
  type: 'eval',
  name: 'date_trunc',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.date_trunc', {
    defaultMessage: 'Rounds down a date to the closest interval.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'interval',
      type: 'time_literal',
      optional: false
    }, {
      name: 'date',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'interval',
      type: 'time_duration',
      optional: false
    }, {
      name: 'date',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP first_name, last_name, hire_date\n| EVAL year_hired = DATE_TRUNC(1 year, hire_date)', 'FROM employees\n| EVAL year = DATE_TRUNC(1 year, hire_date)\n| STATS hires = COUNT(emp_no) BY year\n| SORT year', 'FROM sample_data\n| EVAL error = CASE(message LIKE "*error*", 1, 0)\n| EVAL hour = DATE_TRUNC(1 hour, @timestamp)\n| STATS error_rate = AVG(error) by hour\n| SORT hour']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const eDefinition = {
  type: 'eval',
  name: 'e',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.e', {
    defaultMessage: "Returns Euler's number."
  }),
  alias: undefined,
  signatures: [{
    params: [],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW E()']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const endsWithDefinition = {
  type: 'eval',
  name: 'ends_with',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ends_with', {
    defaultMessage: 'Returns a boolean that indicates whether a keyword string ends with another string.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }, {
      name: 'suffix',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }, {
      name: 'suffix',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }, {
      name: 'suffix',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }, {
      name: 'suffix',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP last_name\n| EVAL ln_E = ENDS_WITH(last_name, "d")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const expDefinition = {
  type: 'eval',
  name: 'exp',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.exp', {
    defaultMessage: 'Returns the value of e raised to the power of the given number.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW d = 5.0\n| EVAL s = EXP(d)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const floorDefinition = {
  type: 'eval',
  name: 'floor',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.floor', {
    defaultMessage: 'Round a number down to the nearest integer.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=1.8\n| EVAL a=FLOOR(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const fromBase64Definition = {
  type: 'eval',
  name: 'from_base64',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.from_base64', {
    defaultMessage: 'Decode a base64 string.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['row a = "ZWxhc3RpYw==" \n| eval d = from_base64(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const greatestDefinition = {
  type: 'eval',
  name: 'greatest',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.greatest', {
    defaultMessage: 'Returns the maximum value from multiple columns. This is similar to `MV_MAX`\nexcept it is intended to run on multiple columns at once.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'first',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'boolean',
      optional: false
    }, {
      name: 'rest',
      type: 'boolean',
      optional: true
    }],
    returnType: 'boolean',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'date',
      optional: false
    }, {
      name: 'rest',
      type: 'date',
      optional: true
    }],
    returnType: 'date',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'double',
      optional: false
    }, {
      name: 'rest',
      type: 'double',
      optional: true
    }],
    returnType: 'double',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'integer',
      optional: false
    }, {
      name: 'rest',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'ip',
      optional: false
    }, {
      name: 'rest',
      type: 'ip',
      optional: true
    }],
    returnType: 'ip',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'keyword',
      optional: false
    }, {
      name: 'rest',
      type: 'keyword',
      optional: true
    }],
    returnType: 'keyword',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'long',
      optional: false
    }],
    returnType: 'long',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'long',
      optional: false
    }, {
      name: 'rest',
      type: 'long',
      optional: true
    }],
    returnType: 'long',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'text',
      optional: false
    }],
    returnType: 'text',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'text',
      optional: false
    }, {
      name: 'rest',
      type: 'text',
      optional: true
    }],
    returnType: 'text',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'version',
      optional: false
    }, {
      name: 'rest',
      type: 'version',
      optional: true
    }],
    returnType: 'version',
    minParams: 1
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a = 10, b = 20\n| EVAL g = GREATEST(a, b)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const hypotDefinition = {
  type: 'eval',
  name: 'hypot',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.hypot', {
    defaultMessage: 'Returns the hypotenuse of two numbers. The input can be any numeric values, the return value is always a double.\nHypotenuses of infinities are null.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number1',
      type: 'double',
      optional: false
    }, {
      name: 'number2',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'double',
      optional: false
    }, {
      name: 'number2',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'double',
      optional: false
    }, {
      name: 'number2',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'double',
      optional: false
    }, {
      name: 'number2',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'integer',
      optional: false
    }, {
      name: 'number2',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'integer',
      optional: false
    }, {
      name: 'number2',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'integer',
      optional: false
    }, {
      name: 'number2',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'integer',
      optional: false
    }, {
      name: 'number2',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'long',
      optional: false
    }, {
      name: 'number2',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'long',
      optional: false
    }, {
      name: 'number2',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'long',
      optional: false
    }, {
      name: 'number2',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'long',
      optional: false
    }, {
      name: 'number2',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'number2',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'number2',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'number2',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number1',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'number2',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a = 3.0, b = 4.0\n| EVAL c = HYPOT(a, b)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const ipPrefixDefinition = {
  type: 'eval',
  name: 'ip_prefix',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ip_prefix', {
    defaultMessage: 'Truncates an IP to a given prefix length.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'ip',
      type: 'ip',
      optional: false
    }, {
      name: 'prefixLengthV4',
      type: 'integer',
      optional: false
    }, {
      name: 'prefixLengthV6',
      type: 'integer',
      optional: false
    }],
    returnType: 'ip'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['row ip4 = to_ip("1.2.3.4"), ip6 = to_ip("fe80::cae2:65ff:fece:feb9")\n| eval ip4_prefix = ip_prefix(ip4, 24, 0), ip6_prefix = ip_prefix(ip6, 0, 112);']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const leastDefinition = {
  type: 'eval',
  name: 'least',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.least', {
    defaultMessage: 'Returns the minimum value from multiple columns. This is similar to `MV_MIN` except it is intended to run on multiple columns at once.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'first',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'boolean',
      optional: false
    }, {
      name: 'rest',
      type: 'boolean',
      optional: true
    }],
    returnType: 'boolean',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'date',
      optional: false
    }, {
      name: 'rest',
      type: 'date',
      optional: true
    }],
    returnType: 'date',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'double',
      optional: false
    }, {
      name: 'rest',
      type: 'double',
      optional: true
    }],
    returnType: 'double',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'integer',
      optional: false
    }, {
      name: 'rest',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'ip',
      optional: false
    }, {
      name: 'rest',
      type: 'ip',
      optional: true
    }],
    returnType: 'ip',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'keyword',
      optional: false
    }, {
      name: 'rest',
      type: 'keyword',
      optional: true
    }],
    returnType: 'keyword',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'long',
      optional: false
    }],
    returnType: 'long',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'long',
      optional: false
    }, {
      name: 'rest',
      type: 'long',
      optional: true
    }],
    returnType: 'long',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'text',
      optional: false
    }],
    returnType: 'text',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'text',
      optional: false
    }, {
      name: 'rest',
      type: 'text',
      optional: true
    }],
    returnType: 'text',
    minParams: 1
  }, {
    params: [{
      name: 'first',
      type: 'version',
      optional: false
    }, {
      name: 'rest',
      type: 'version',
      optional: true
    }],
    returnType: 'version',
    minParams: 1
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a = 10, b = 20\n| EVAL l = LEAST(a, b)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const leftDefinition = {
  type: 'eval',
  name: 'left',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.left', {
    defaultMessage: "Returns the substring that extracts 'length' chars from 'string' starting from the left."
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'length',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'length',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP last_name\n| EVAL left = LEFT(last_name, 3)\n| SORT last_name ASC\n| LIMIT 5']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const lengthDefinition = {
  type: 'eval',
  name: 'length',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.length', {
    defaultMessage: 'Returns the character length of a string.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }],
    returnType: 'integer'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP first_name, last_name\n| EVAL fn_length = LENGTH(first_name)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const locateDefinition = {
  type: 'eval',
  name: 'locate',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.locate', {
    defaultMessage: 'Returns an integer that indicates the position of a keyword substring within another string.\nReturns `0` if the substring cannot be found.\nNote that string positions start from `1`.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'substring',
      type: 'keyword',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'substring',
      type: 'keyword',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'substring',
      type: 'text',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'substring',
      type: 'text',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'substring',
      type: 'keyword',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'substring',
      type: 'keyword',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'substring',
      type: 'text',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'substring',
      type: 'text',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['row a = "hello"\n| eval a_ll = locate(a, "ll")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const logDefinition = {
  type: 'eval',
  name: 'log',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.log', {
    defaultMessage: 'Returns the logarithm of a value to a base. The input can be any numeric value, the return value is always a double.\n\nLogs of zero, negative numbers, and base of one return `null` as well as a warning.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'base',
      type: 'double',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'double',
      optional: true
    }, {
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'double',
      optional: true
    }, {
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'double',
      optional: true
    }, {
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'double',
      optional: true
    }, {
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: true
    }, {
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: true
    }, {
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: true
    }, {
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: true
    }, {
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: true
    }, {
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: true
    }, {
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: true
    }, {
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: true
    }, {
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: true
    }, {
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: true
    }, {
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: true
    }, {
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: true
    }, {
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: fnDef => {
    const messages = [];
    // do not really care here about the base and field
    // just need to check both values are not negative
    for (const arg of fnDef.args) {
      if ((0, _helpers.isLiteralItem)(arg) && Number(arg.value) < 0) {
        messages.push({
          type: 'warning',
          code: 'logOfNegativeValue',
          text: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.divide.warning.logOfNegativeValue', {
            defaultMessage: 'Log of a negative number results in null: {value}',
            values: {
              value: arg.value
            }
          }),
          location: arg.location
        });
      }
    }
    return messages;
  },
  examples: ['ROW base = 2.0, value = 8.0\n| EVAL s = LOG(base, value)', 'row value = 100\n| EVAL s = LOG(value);']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const log10Definition = {
  type: 'eval',
  name: 'log10',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.log10', {
    defaultMessage: 'Returns the logarithm of a value to base 10. The input can be any numeric value, the return value is always a double.\n\nLogs of 0 and negative numbers return `null` as well as a warning.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: fnDef => {
    const messages = [];
    // do not really care here about the base and field
    // just need to check both values are not negative
    for (const arg of fnDef.args) {
      if ((0, _helpers.isLiteralItem)(arg) && Number(arg.value) < 0) {
        messages.push({
          type: 'warning',
          code: 'logOfNegativeValue',
          text: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.divide.warning.logOfNegativeValue', {
            defaultMessage: 'Log of a negative number results in null: {value}',
            values: {
              value: arg.value
            }
          }),
          location: arg.location
        });
      }
    }
    return messages;
  },
  examples: ['ROW d = 1000.0 \n| EVAL s = LOG10(d)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const ltrimDefinition = {
  type: 'eval',
  name: 'ltrim',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ltrim', {
    defaultMessage: 'Removes leading whitespaces from a string.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW message = "   some text  ",  color = " red "\n| EVAL message = LTRIM(message)\n| EVAL color = LTRIM(color)\n| EVAL message = CONCAT("\'", message, "\'")\n| EVAL color = CONCAT("\'", color, "\'")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const matchDefinition = {
  type: 'eval',
  name: 'match',
  ignoreAsSuggestion: true,
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.match', {
    defaultMessage: 'Performs a match query on the specified field. Returns true if the provided query matches the row.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'query',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'query',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'query',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'query',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['from books \n| where match(author, "Faulkner")\n| keep book_no, author \n| sort book_no \n| limit 5;']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvAppendDefinition = {
  type: 'eval',
  name: 'mv_append',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_append', {
    defaultMessage: 'Concatenates values of two multi-value fields.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field1',
      type: 'boolean',
      optional: false
    }, {
      name: 'field2',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field1',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'field2',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field1',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'field2',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field1',
      type: 'date',
      optional: false
    }, {
      name: 'field2',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field1',
      type: 'double',
      optional: false
    }, {
      name: 'field2',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field1',
      type: 'geo_point',
      optional: false
    }, {
      name: 'field2',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field1',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'field2',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field1',
      type: 'integer',
      optional: false
    }, {
      name: 'field2',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field1',
      type: 'ip',
      optional: false
    }, {
      name: 'field2',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field1',
      type: 'keyword',
      optional: false
    }, {
      name: 'field2',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field1',
      type: 'long',
      optional: false
    }, {
      name: 'field2',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field1',
      type: 'text',
      optional: false
    }, {
      name: 'field2',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }, {
    params: [{
      name: 'field1',
      type: 'version',
      optional: false
    }, {
      name: 'field2',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvAvgDefinition = {
  type: 'eval',
  name: 'mv_avg',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_avg', {
    defaultMessage: 'Converts a multivalued field into a single valued field containing the average of all of the values.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=[3, 5, 1, 6]\n| EVAL avg_a = MV_AVG(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvConcatDefinition = {
  type: 'eval',
  name: 'mv_concat',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_concat', {
    defaultMessage: 'Converts a multivalued string expression into a single valued column containing the concatenation of all values separated by a delimiter.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'delim',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'delim',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'delim',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'delim',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=["foo", "zoo", "bar"]\n| EVAL j = MV_CONCAT(a, ", ")', 'ROW a=[10, 9, 8]\n| EVAL j = MV_CONCAT(TO_STRING(a), ", ")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvCountDefinition = {
  type: 'eval',
  name: 'mv_count',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_count', {
    defaultMessage: 'Converts a multivalued expression into a single valued column containing a count of the number of values.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'integer'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=["foo", "zoo", "bar"]\n| EVAL count_a = MV_COUNT(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvDedupeDefinition = {
  type: 'eval',
  name: 'mv_dedupe',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_dedupe', {
    defaultMessage: 'Remove duplicate values from a multivalued field.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=["foo", "foo", "bar", "foo"]\n| EVAL dedupe_a = MV_DEDUPE(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvFirstDefinition = {
  type: 'eval',
  name: 'mv_first',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_first', {
    defaultMessage: 'Converts a multivalued expression into a single valued column containing the\nfirst value. This is most useful when reading from a function that emits\nmultivalued columns in a known order like `SPLIT`.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a="foo;bar;baz"\n| EVAL first_a = MV_FIRST(SPLIT(a, ";"))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvLastDefinition = {
  type: 'eval',
  name: 'mv_last',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_last', {
    defaultMessage: 'Converts a multivalue expression into a single valued column containing the last\nvalue. This is most useful when reading from a function that emits multivalued\ncolumns in a known order like `SPLIT`.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a="foo;bar;baz"\n| EVAL last_a = MV_LAST(SPLIT(a, ";"))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvMaxDefinition = {
  type: 'eval',
  name: 'mv_max',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_max', {
    defaultMessage: 'Converts a multivalued expression into a single valued column containing the maximum value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=[3, 5, 1]\n| EVAL max_a = MV_MAX(a)', 'ROW a=["foo", "zoo", "bar"]\n| EVAL max_a = MV_MAX(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvMedianDefinition = {
  type: 'eval',
  name: 'mv_median',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_median', {
    defaultMessage: 'Converts a multivalued field into a single valued field containing the median value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=[3, 5, 1]\n| EVAL median_a = MV_MEDIAN(a)', 'ROW a=[3, 7, 1, 6]\n| EVAL median_a = MV_MEDIAN(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvMedianAbsoluteDeviationDefinition = {
  type: 'eval',
  name: 'mv_median_absolute_deviation',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_median_absolute_deviation', {
    defaultMessage: "Converts a multivalued field into a single valued field containing the median absolute deviation.\n\nIt is calculated as the median of each data point's deviation from the median of the entire sample. That is, for a random variable `X`, the median absolute deviation is `median(|median(X) - X|)`."
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW values = [0, 2, 5, 6]\n| EVAL median_absolute_deviation = MV_MEDIAN_ABSOLUTE_DEVIATION(values), median = MV_MEDIAN(values)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvMinDefinition = {
  type: 'eval',
  name: 'mv_min',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_min', {
    defaultMessage: 'Converts a multivalued expression into a single valued column containing the minimum value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=[2, 1]\n| EVAL min_a = MV_MIN(a)', 'ROW a=["foo", "bar"]\n| EVAL min_a = MV_MIN(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvPercentileDefinition = {
  type: 'eval',
  name: 'mv_percentile',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_percentile', {
    defaultMessage: 'Converts a multivalued field into a single valued field containing the value at which a certain percentage of observed values occur.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW values = [5, 5, 10, 12, 5000]\n| EVAL p50 = MV_PERCENTILE(values, 50), median = MV_MEDIAN(values)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvPseriesWeightedSumDefinition = {
  type: 'eval',
  name: 'mv_pseries_weighted_sum',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_pseries_weighted_sum', {
    defaultMessage: 'Converts a multivalued expression into a single-valued column by multiplying every element on the input list by its corresponding term in P-Series and computing the sum.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'p',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a = [70.0, 45.0, 21.0, 21.0, 21.0]\n| EVAL sum = MV_PSERIES_WEIGHTED_SUM(a, 1.5)\n| KEEP sum']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvSliceDefinition = {
  type: 'eval',
  name: 'mv_slice',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_slice', {
    defaultMessage: 'Returns a subset of the multivalued field using the start and end index values.\nThis is most useful when reading from a function that emits multivalued columns\nin a known order like `SPLIT` or `MV_SORT`.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'text'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'end',
      type: 'integer',
      optional: true
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['row a = [1, 2, 2, 3]\n| eval a1 = mv_slice(a, 1), a2 = mv_slice(a, 2, 3)', 'row a = [1, 2, 2, 3]\n| eval a1 = mv_slice(a, -2), a2 = mv_slice(a, -3, -1)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvSortDefinition = {
  type: 'eval',
  name: 'mv_sort',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_sort', {
    defaultMessage: 'Sorts a multivalued field in lexicographical order.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'text'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      acceptedValues: ['asc', 'desc']
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a = [4, 2, -3, 2]\n| EVAL sa = mv_sort(a), sd = mv_sort(a, "DESC")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvSumDefinition = {
  type: 'eval',
  name: 'mv_sum',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_sum', {
    defaultMessage: 'Converts a multivalued field into a single valued field containing the sum of all of the values.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=[3, 5, 6]\n| EVAL sum_a = MV_SUM(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const mvZipDefinition = {
  type: 'eval',
  name: 'mv_zip',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.mv_zip', {
    defaultMessage: 'Combines the values from two multivalued fields with a delimiter that joins them together.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string1',
      type: 'keyword',
      optional: false
    }, {
      name: 'string2',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'keyword',
      optional: false
    }, {
      name: 'string2',
      type: 'keyword',
      optional: false
    }, {
      name: 'delim',
      type: 'keyword',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'keyword',
      optional: false
    }, {
      name: 'string2',
      type: 'keyword',
      optional: false
    }, {
      name: 'delim',
      type: 'text',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'keyword',
      optional: false
    }, {
      name: 'string2',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'keyword',
      optional: false
    }, {
      name: 'string2',
      type: 'text',
      optional: false
    }, {
      name: 'delim',
      type: 'keyword',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'keyword',
      optional: false
    }, {
      name: 'string2',
      type: 'text',
      optional: false
    }, {
      name: 'delim',
      type: 'text',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'text',
      optional: false
    }, {
      name: 'string2',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'text',
      optional: false
    }, {
      name: 'string2',
      type: 'keyword',
      optional: false
    }, {
      name: 'delim',
      type: 'keyword',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'text',
      optional: false
    }, {
      name: 'string2',
      type: 'keyword',
      optional: false
    }, {
      name: 'delim',
      type: 'text',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'text',
      optional: false
    }, {
      name: 'string2',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'text',
      optional: false
    }, {
      name: 'string2',
      type: 'text',
      optional: false
    }, {
      name: 'delim',
      type: 'keyword',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string1',
      type: 'text',
      optional: false
    }, {
      name: 'string2',
      type: 'text',
      optional: false
    }, {
      name: 'delim',
      type: 'text',
      optional: true
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a = ["x", "y", "z"], b = ["1", "2"]\n| EVAL c = mv_zip(a, b, "-")\n| KEEP a, b, c']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const nowDefinition = {
  type: 'eval',
  name: 'now',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.now', {
    defaultMessage: 'Returns current date and time.'
  }),
  alias: undefined,
  signatures: [{
    params: [],
    returnType: 'date'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW current_date = NOW()', 'FROM sample_data\n| WHERE @timestamp > NOW() - 1 hour']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const piDefinition = {
  type: 'eval',
  name: 'pi',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.pi', {
    defaultMessage: "Returns Pi, the ratio of a circle's circumference to its diameter."
  }),
  alias: undefined,
  signatures: [{
    params: [],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW PI()']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const powDefinition = {
  type: 'eval',
  name: 'pow',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.pow', {
    defaultMessage: 'Returns the value of `base` raised to the power of `exponent`.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'base',
      type: 'double',
      optional: false
    }, {
      name: 'exponent',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'double',
      optional: false
    }, {
      name: 'exponent',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'double',
      optional: false
    }, {
      name: 'exponent',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'double',
      optional: false
    }, {
      name: 'exponent',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: false
    }, {
      name: 'exponent',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: false
    }, {
      name: 'exponent',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: false
    }, {
      name: 'exponent',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'integer',
      optional: false
    }, {
      name: 'exponent',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: false
    }, {
      name: 'exponent',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: false
    }, {
      name: 'exponent',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: false
    }, {
      name: 'exponent',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'long',
      optional: false
    }, {
      name: 'exponent',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'exponent',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'exponent',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'exponent',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'base',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'exponent',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW base = 2.0, exponent = 2\n| EVAL result = POW(base, exponent)', 'ROW base = 4, exponent = 0.5\n| EVAL s = POW(base, exponent)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const qstrDefinition = {
  type: 'eval',
  name: 'qstr',
  ignoreAsSuggestion: true,
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.qstr', {
    defaultMessage: 'Performs a query string query. Returns true if the provided query string matches the row.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'query',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'query',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['from books \n| where qstr("author: Faulkner")\n| keep book_no, author \n| sort book_no \n| limit 5;']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const repeatDefinition = {
  type: 'eval',
  name: 'repeat',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.repeat', {
    defaultMessage: 'Returns a string constructed by concatenating `string` with itself the specified `number` of times.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a = "Hello!"\n| EVAL triple_a = REPEAT(a, 3);']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const replaceDefinition = {
  type: 'eval',
  name: 'replace',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.replace', {
    defaultMessage: 'The function substitutes in the string `str` any match of the regular expression `regex`\nwith the replacement string `newStr`.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'regex',
      type: 'keyword',
      optional: false
    }, {
      name: 'newString',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'regex',
      type: 'keyword',
      optional: false
    }, {
      name: 'newString',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'regex',
      type: 'text',
      optional: false
    }, {
      name: 'newString',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'regex',
      type: 'text',
      optional: false
    }, {
      name: 'newString',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'regex',
      type: 'keyword',
      optional: false
    }, {
      name: 'newString',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'regex',
      type: 'keyword',
      optional: false
    }, {
      name: 'newString',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'regex',
      type: 'text',
      optional: false
    }, {
      name: 'newString',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'regex',
      type: 'text',
      optional: false
    }, {
      name: 'newString',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW str = "Hello World"\n| EVAL str = REPLACE(str, "World", "Universe")\n| KEEP str']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const reverseDefinition = {
  type: 'eval',
  name: 'reverse',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.reverse', {
    defaultMessage: 'Returns a new string representing the input string in reverse order.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW message = "Some Text" | EVAL message_reversed = REVERSE(message);', 'ROW bending_arts = "💧🪨🔥💨" | EVAL bending_arts_reversed = REVERSE(bending_arts);']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const rightDefinition = {
  type: 'eval',
  name: 'right',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.right', {
    defaultMessage: "Return the substring that extracts 'length' chars from 'str' starting from the right."
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'length',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'length',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP last_name\n| EVAL right = RIGHT(last_name, 3)\n| SORT last_name ASC\n| LIMIT 5']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const roundDefinition = {
  type: 'eval',
  name: 'round',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.round', {
    defaultMessage: 'Rounds a number to the specified number of decimal places.\nDefaults to 0, which returns the nearest integer. If the\nprecision is a negative number, rounds to the number of digits left\nof the decimal point.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'decimals',
      type: 'integer',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'decimals',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'decimals',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP first_name, last_name, height\n| EVAL height_ft = ROUND(height * 3.281, 1)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const rtrimDefinition = {
  type: 'eval',
  name: 'rtrim',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.rtrim', {
    defaultMessage: 'Removes trailing whitespaces from a string.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW message = "   some text  ",  color = " red "\n| EVAL message = RTRIM(message)\n| EVAL color = RTRIM(color)\n| EVAL message = CONCAT("\'", message, "\'")\n| EVAL color = CONCAT("\'", color, "\'")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const signumDefinition = {
  type: 'eval',
  name: 'signum',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.signum', {
    defaultMessage: 'Returns the sign of the given number.\nIt returns `-1` for negative numbers, `0` for `0` and `1` for positive numbers.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW d = 100.0\n| EVAL s = SIGNUM(d)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sinDefinition = {
  type: 'eval',
  name: 'sin',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.sin', {
    defaultMessage: 'Returns the sine of an angle.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'angle',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=1.8 \n| EVAL sin=SIN(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sinhDefinition = {
  type: 'eval',
  name: 'sinh',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.sinh', {
    defaultMessage: 'Returns the hyperbolic sine of a number.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=1.8 \n| EVAL sinh=SINH(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const spaceDefinition = {
  type: 'eval',
  name: 'space',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.space', {
    defaultMessage: 'Returns a string made of `number` spaces.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW message = CONCAT("Hello", SPACE(1), "World!");']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const splitDefinition = {
  type: 'eval',
  name: 'split',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.split', {
    defaultMessage: 'Split a single valued string into multiple strings.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'delim',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'delim',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'delim',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'delim',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW words="foo;bar;baz;qux;quux;corge"\n| EVAL word = SPLIT(words, ";")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sqrtDefinition = {
  type: 'eval',
  name: 'sqrt',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.sqrt', {
    defaultMessage: 'Returns the square root of a number. The input can be any numeric value, the return value is always a double.\nSquare roots of negative numbers and infinities are null.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW d = 100.0\n| EVAL s = SQRT(d)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stContainsDefinition = {
  type: 'eval',
  name: 'st_contains',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.st_contains', {
    defaultMessage: 'Returns whether the first geometry contains the second geometry.\nThis is the inverse of the `ST_WITHIN` function.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM airport_city_boundaries\n| WHERE ST_CONTAINS(city_boundary, TO_GEOSHAPE("POLYGON((109.35 18.3, 109.45 18.3, 109.45 18.4, 109.35 18.4, 109.35 18.3))"))\n| KEEP abbrev, airport, region, city, city_location']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stDisjointDefinition = {
  type: 'eval',
  name: 'st_disjoint',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.st_disjoint', {
    defaultMessage: 'Returns whether the two geometries or geometry columns are disjoint.\nThis is the inverse of the `ST_INTERSECTS` function.\nIn mathematical terms: ST_Disjoint(A, B) ⇔ A ⋂ B = ∅'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM airport_city_boundaries\n| WHERE ST_DISJOINT(city_boundary, TO_GEOSHAPE("POLYGON((-10 -60, 120 -60, 120 60, -10 60, -10 -60))"))\n| KEEP abbrev, airport, region, city, city_location']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stDistanceDefinition = {
  type: 'eval',
  name: 'st_distance',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.st_distance', {
    defaultMessage: 'Computes the distance between two points.\nFor cartesian geometries, this is the pythagorean distance in the same units as the original coordinates.\nFor geographic geometries, this is the circular distance along the great circle in meters.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM airports\n| WHERE abbrev == "CPH"\n| EVAL distance = ST_DISTANCE(location, city_location)\n| KEEP abbrev, name, location, city_location, distance']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stIntersectsDefinition = {
  type: 'eval',
  name: 'st_intersects',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.st_intersects', {
    defaultMessage: 'Returns true if two geometries intersect.\nThey intersect if they have any point in common, including their interior points\n(points along lines or within polygons).\nThis is the inverse of the `ST_DISJOINT` function.\nIn mathematical terms: ST_Intersects(A, B) ⇔ A ⋂ B ≠ ∅'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM airports\n| WHERE ST_INTERSECTS(location, TO_GEOSHAPE("POLYGON((42 14, 43 14, 43 15, 42 15, 42 14))"))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stWithinDefinition = {
  type: 'eval',
  name: 'st_within',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.st_within', {
    defaultMessage: 'Returns whether the first geometry is within the second geometry.\nThis is the inverse of the `ST_CONTAINS` function.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_point',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'geomA',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'geomB',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM airport_city_boundaries\n| WHERE ST_WITHIN(city_boundary, TO_GEOSHAPE("POLYGON((109.1 18.15, 109.6 18.15, 109.6 18.65, 109.1 18.65, 109.1 18.15))"))\n| KEEP abbrev, airport, region, city, city_location']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stXDefinition = {
  type: 'eval',
  name: 'st_x',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.st_x', {
    defaultMessage: 'Extracts the `x` coordinate from the supplied point.\nIf the points is of type `geo_point` this is equivalent to extracting the `longitude` value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'point',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'point',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW point = TO_GEOPOINT("POINT(42.97109629958868 14.7552534006536)")\n| EVAL x =  ST_X(point), y = ST_Y(point)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stYDefinition = {
  type: 'eval',
  name: 'st_y',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.st_y', {
    defaultMessage: 'Extracts the `y` coordinate from the supplied point.\nIf the points is of type `geo_point` this is equivalent to extracting the `latitude` value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'point',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'point',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW point = TO_GEOPOINT("POINT(42.97109629958868 14.7552534006536)")\n| EVAL x =  ST_X(point), y = ST_Y(point)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const startsWithDefinition = {
  type: 'eval',
  name: 'starts_with',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.starts_with', {
    defaultMessage: 'Returns a boolean that indicates whether a keyword string starts with another string.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }, {
      name: 'prefix',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }, {
      name: 'prefix',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }, {
      name: 'prefix',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }, {
      name: 'prefix',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP last_name\n| EVAL ln_S = STARTS_WITH(last_name, "B")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const substringDefinition = {
  type: 'eval',
  name: 'substring',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.substring', {
    defaultMessage: 'Returns a substring of a string, specified by a start position and an optional length.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'length',
      type: 'integer',
      optional: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }, {
      name: 'start',
      type: 'integer',
      optional: false
    }, {
      name: 'length',
      type: 'integer',
      optional: true
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['FROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, 1, 3)', 'FROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, -3, 3)', 'FROM employees\n| KEEP last_name\n| EVAL ln_sub = SUBSTRING(last_name, 2)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const tanDefinition = {
  type: 'eval',
  name: 'tan',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.tan', {
    defaultMessage: 'Returns the tangent of an angle.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'angle',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'angle',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=1.8 \n| EVAL tan=TAN(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const tanhDefinition = {
  type: 'eval',
  name: 'tanh',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.tanh', {
    defaultMessage: 'Returns the hyperbolic tangent of a number.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=1.8 \n| EVAL tanh=TANH(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const tauDefinition = {
  type: 'eval',
  name: 'tau',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.tau', {
    defaultMessage: "Returns the ratio of a circle's circumference to its radius."
  }),
  alias: undefined,
  signatures: [{
    params: [],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW TAU()']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toBase64Definition = {
  type: 'eval',
  name: 'to_base64',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_base64', {
    defaultMessage: 'Encode a string to a base64 string.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['row a = "elastic" \n| eval e = to_base64(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toBooleanDefinition = {
  type: 'eval',
  name: 'to_boolean',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_boolean', {
    defaultMessage: 'Converts an input value to a boolean value.\nA string value of *true* will be case-insensitive converted to the Boolean *true*.\nFor anything else, including the empty string, the function will return *false*.\nThe numerical value of *0* will be converted to *false*, anything else will be converted to *true*.'
  }),
  alias: ['to_bool'],
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW str = ["true", "TRuE", "false", "", "yes", "1"]\n| EVAL bool = TO_BOOLEAN(str)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toCartesianpointDefinition = {
  type: 'eval',
  name: 'to_cartesianpoint',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_cartesianpoint', {
    defaultMessage: 'Converts an input value to a `cartesian_point` value.\nA string will only be successfully converted if it respects WKT Point format.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'cartesian_point'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW wkt = ["POINT(4297.11 -1475.53)", "POINT(7580.93 2272.77)"]\n| MV_EXPAND wkt\n| EVAL pt = TO_CARTESIANPOINT(wkt)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toCartesianshapeDefinition = {
  type: 'eval',
  name: 'to_cartesianshape',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_cartesianshape', {
    defaultMessage: 'Converts an input value to a `cartesian_shape` value.\nA string will only be successfully converted if it respects WKT format.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW wkt = ["POINT(4297.11 -1475.53)", "POLYGON ((3339584.72 1118889.97, 4452779.63 4865942.27, 2226389.81 4865942.27, 1113194.90 2273030.92, 3339584.72 1118889.97))"]\n| MV_EXPAND wkt\n| EVAL geom = TO_CARTESIANSHAPE(wkt)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDateNanosDefinition = {
  type: 'eval',
  name: 'to_date_nanos',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_date_nanos', {
    defaultMessage: 'Converts an input to a nanosecond-resolution date value (aka date_nanos).'
  }),
  alias: undefined,
  signatures: [],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: []
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDateperiodDefinition = {
  type: 'eval',
  name: 'to_dateperiod',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_dateperiod', {
    defaultMessage: 'Converts an input value into a `date_period` value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'date_period',
      optional: false
    }],
    returnType: 'date_period'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'date_period'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'date_period'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['row x = "2024-01-01"::datetime | eval y = x + "3 DAYS"::date_period, z = x - to_dateperiod("3 days");']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDatetimeDefinition = {
  type: 'eval',
  name: 'to_datetime',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_datetime', {
    defaultMessage: "Converts an input value to a date value.\nA string will only be successfully converted if it's respecting the format `yyyy-MM-dd'T'HH:mm:ss.SSS'Z'`.\nTo convert dates in other formats, use `DATE_PARSE`."
  }),
  alias: ['to_dt'],
  signatures: [{
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'date'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW string = ["1953-09-02T00:00:00.000Z", "1964-06-02T00:00:00.000Z", "1964-06-02 00:00:00"]\n| EVAL datetime = TO_DATETIME(string)', 'ROW int = [0, 1]\n| EVAL dt = TO_DATETIME(int)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDegreesDefinition = {
  type: 'eval',
  name: 'to_degrees',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_degrees', {
    defaultMessage: 'Converts a number in radians to degrees.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW rad = [1.57, 3.14, 4.71]\n| EVAL deg = TO_DEGREES(rad)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toDoubleDefinition = {
  type: 'eval',
  name: 'to_double',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_double', {
    defaultMessage: 'Converts an input value to a double value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the Unix epoch,\nconverted to double. Boolean *true* will be converted to double *1.0*, *false* to *0.0*.'
  }),
  alias: ['to_dbl'],
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW str1 = "5.20128E11", str2 = "foo"\n| EVAL dbl = TO_DOUBLE("520128000000"), dbl1 = TO_DOUBLE(str1), dbl2 = TO_DOUBLE(str2)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toGeopointDefinition = {
  type: 'eval',
  name: 'to_geopoint',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_geopoint', {
    defaultMessage: 'Converts an input value to a `geo_point` value.\nA string will only be successfully converted if it respects WKT Point format.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'geo_point'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW wkt = "POINT(42.97109630194 14.7552534413725)"\n| EVAL pt = TO_GEOPOINT(wkt)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toGeoshapeDefinition = {
  type: 'eval',
  name: 'to_geoshape',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_geoshape', {
    defaultMessage: 'Converts an input value to a `geo_shape` value.\nA string will only be successfully converted if it respects WKT format.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'geo_shape'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW wkt = "POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))"\n| EVAL geom = TO_GEOSHAPE(wkt)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toIntegerDefinition = {
  type: 'eval',
  name: 'to_integer',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_integer', {
    defaultMessage: 'Converts an input value to an integer value.\nIf the input parameter is of a date type, its value will be interpreted as milliseconds\nsince the Unix epoch, converted to integer.\nBoolean *true* will be converted to integer *1*, *false* to *0*.'
  }),
  alias: ['to_int'],
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'counter_integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'integer'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW long = [5013792, 2147483647, 501379200000]\n| EVAL int = TO_INTEGER(long)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toIpDefinition = {
  type: 'eval',
  name: 'to_ip',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_ip', {
    defaultMessage: 'Converts an input string to an IP value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'ip'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW str1 = "1.1.1.1", str2 = "foo"\n| EVAL ip1 = TO_IP(str1), ip2 = TO_IP(str2)\n| WHERE CIDR_MATCH(ip1, "1.0.0.0/8")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toLongDefinition = {
  type: 'eval',
  name: 'to_long',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_long', {
    defaultMessage: 'Converts an input value to a long value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the Unix epoch, converted to long.\nBoolean *true* will be converted to long *1*, *false* to *0*.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'counter_integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'counter_long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW str1 = "2147483648", str2 = "2147483648.2", str3 = "foo"\n| EVAL long1 = TO_LONG(str1), long2 = TO_LONG(str2), long3 = TO_LONG(str3)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toLowerDefinition = {
  type: 'eval',
  name: 'to_lower',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_lower', {
    defaultMessage: 'Returns a new string representing the input string converted to lower case.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW message = "Some Text"\n| EVAL message_lower = TO_LOWER(message)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toRadiansDefinition = {
  type: 'eval',
  name: 'to_radians',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_radians', {
    defaultMessage: 'Converts a number in degrees to radians.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'double'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW deg = [90.0, 180.0, 270.0]\n| EVAL rad = TO_RADIANS(deg)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toStringDefinition = {
  type: 'eval',
  name: 'to_string',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_string', {
    defaultMessage: 'Converts an input value into a string.'
  }),
  alias: ['to_str'],
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'keyword'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW a=10\n| EVAL j = TO_STRING(a)', 'ROW a=[10, 9, 8]\n| EVAL j = TO_STRING(a)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toTimedurationDefinition = {
  type: 'eval',
  name: 'to_timeduration',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_timeduration', {
    defaultMessage: 'Converts an input value into a `time_duration` value.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'time_duration'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'time_duration'
  }, {
    params: [{
      name: 'field',
      type: 'time_duration',
      optional: false
    }],
    returnType: 'time_duration'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['row x = "2024-01-01"::datetime | eval y = x + "3 hours"::time_duration, z = x - to_timeduration("3 hours");']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toUnsignedLongDefinition = {
  type: 'eval',
  name: 'to_unsigned_long',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_unsigned_long', {
    defaultMessage: 'Converts an input value to an unsigned long value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the Unix epoch, converted to unsigned long.\nBoolean *true* will be converted to unsigned long *1*, *false* to *0*.'
  }),
  alias: ['to_ul', 'to_ulong'],
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW str1 = "2147483648", str2 = "2147483648.2", str3 = "foo"\n| EVAL long1 = TO_UNSIGNED_LONG(str1), long2 = TO_ULONG(str2), long3 = TO_UL(str3)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toUpperDefinition = {
  type: 'eval',
  name: 'to_upper',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_upper', {
    defaultMessage: 'Returns a new string representing the input string converted to upper case.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'str',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'str',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW message = "Some Text"\n| EVAL message_upper = TO_UPPER(message)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const toVersionDefinition = {
  type: 'eval',
  name: 'to_version',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.to_version', {
    defaultMessage: 'Converts an input string to a version value.'
  }),
  alias: ['to_ver'],
  signatures: [{
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'version'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'version'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW v = TO_VERSION("1.2.3")']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const trimDefinition = {
  type: 'eval',
  name: 'trim',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.trim', {
    defaultMessage: 'Removes leading and trailing whitespaces from a string.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'string',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'string',
      type: 'text',
      optional: false
    }],
    returnType: 'text'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['ROW message = "   some text  ",  color = " red "\n| EVAL message = TRIM(message)\n| EVAL color = TRIM(color)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const caseDefinition = {
  type: 'eval',
  name: 'case',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.case', {
    defaultMessage: 'Accepts pairs of conditions and values. The function returns the value that belongs to the first condition that evaluates to `true`. If the number of arguments is odd, the last argument is the default value which is returned when no condition matches.'
  }),
  alias: undefined,
  signatures: [{
    params: [{
      name: 'condition',
      type: 'boolean'
    }, {
      name: 'value',
      type: 'any'
    }],
    minParams: 2,
    returnType: 'unknown'
  }],
  supportedCommands: ['stats', 'inlinestats', 'metrics', 'eval', 'where', 'row', 'sort'],
  supportedOptions: ['by'],
  validate: undefined,
  examples: ['from index | eval type = case(languages <= 1, "monolingual", languages <= 2, "bilingual", "polyglot")']
};
const scalarFunctionDefinitions = exports.scalarFunctionDefinitions = [absDefinition, acosDefinition, asinDefinition, atanDefinition, atan2Definition, categorizeDefinition, cbrtDefinition, ceilDefinition, cidrMatchDefinition, coalesceDefinition, concatDefinition, cosDefinition, coshDefinition, dateDiffDefinition, dateExtractDefinition, dateFormatDefinition, dateParseDefinition, dateTruncDefinition, eDefinition, endsWithDefinition, expDefinition, floorDefinition, fromBase64Definition, greatestDefinition, hypotDefinition, ipPrefixDefinition, leastDefinition, leftDefinition, lengthDefinition, locateDefinition, logDefinition, log10Definition, ltrimDefinition, matchDefinition, mvAppendDefinition, mvAvgDefinition, mvConcatDefinition, mvCountDefinition, mvDedupeDefinition, mvFirstDefinition, mvLastDefinition, mvMaxDefinition, mvMedianDefinition, mvMedianAbsoluteDeviationDefinition, mvMinDefinition, mvPercentileDefinition, mvPseriesWeightedSumDefinition, mvSliceDefinition, mvSortDefinition, mvSumDefinition, mvZipDefinition, nowDefinition, piDefinition, powDefinition, qstrDefinition, repeatDefinition, replaceDefinition, reverseDefinition, rightDefinition, roundDefinition, rtrimDefinition, signumDefinition, sinDefinition, sinhDefinition, spaceDefinition, splitDefinition, sqrtDefinition, stContainsDefinition, stDisjointDefinition, stDistanceDefinition, stIntersectsDefinition, stWithinDefinition, stXDefinition, stYDefinition, startsWithDefinition, substringDefinition, tanDefinition, tanhDefinition, tauDefinition, toBase64Definition, toBooleanDefinition, toCartesianpointDefinition, toCartesianshapeDefinition, toDateNanosDefinition, toDateperiodDefinition, toDatetimeDefinition, toDegreesDefinition, toDoubleDefinition, toGeopointDefinition, toGeoshapeDefinition, toIntegerDefinition, toIpDefinition, toLongDefinition, toLowerDefinition, toRadiansDefinition, toStringDefinition, toTimedurationDefinition, toUnsignedLongDefinition, toUpperDefinition, toVersionDefinition, trimDefinition, caseDefinition];