"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRecommendedQueriesSuggestions = void 0;
var _templates = require("./templates");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getRecommendedQueriesSuggestions = async (getFieldsByType, fromCommand = '') => {
  const fieldSuggestions = await getFieldsByType('date', [], {
    openSuggestions: true
  });
  let timeField = '';
  if (fieldSuggestions.length) {
    var _fieldSuggestions$fin;
    timeField = (fieldSuggestions === null || fieldSuggestions === void 0 ? void 0 : (_fieldSuggestions$fin = fieldSuggestions.find(field => field.label === '@timestamp')) === null || _fieldSuggestions$fin === void 0 ? void 0 : _fieldSuggestions$fin.label) || fieldSuggestions[0].label;
  }
  const recommendedQueries = (0, _templates.getRecommendedQueries)({
    fromCommand,
    timeField
  });
  const suggestions = recommendedQueries.map(query => {
    return {
      label: query.label,
      text: query.queryString,
      kind: 'Issue',
      detail: query.description,
      sortText: 'D'
    };
  });
  return suggestions;
};
exports.getRecommendedQueriesSuggestions = getRecommendedQueriesSuggestions;