"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialESQLQuery = getInitialESQLQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Builds an ES|QL query for the provided dataView
 * If there is @timestamp field in the index, we don't add the WHERE clause
 * If there is no @timestamp and there is a dataView timeFieldName, we add the WHERE clause with the timeFieldName
 * @param dataView
 */
function getInitialESQLQuery(dataView) {
  var _dataView$fields, _dataView$fields$getB, _dataView$fields$getB2;
  const hasAtTimestampField = (dataView === null || dataView === void 0 ? void 0 : (_dataView$fields = dataView.fields) === null || _dataView$fields === void 0 ? void 0 : (_dataView$fields$getB = _dataView$fields.getByName) === null || _dataView$fields$getB === void 0 ? void 0 : (_dataView$fields$getB2 = _dataView$fields$getB.call(_dataView$fields, '@timestamp')) === null || _dataView$fields$getB2 === void 0 ? void 0 : _dataView$fields$getB2.type) === 'date';
  const timeFieldName = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName;
  const filterByTimeParams = !hasAtTimestampField && timeFieldName ? ` | WHERE ${timeFieldName} >= ?_tstart AND ${timeFieldName} <= ?_tend` : '';
  return `FROM ${dataView.getIndexPattern()}${filterByTimeParams} | LIMIT 10`;
}