"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlQuery = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _parser = require("../parser");
var _wrapping_pretty_printer = require("../pretty_print/wrapping_pretty_printer");
var _EsqlQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class EsqlQuery {
  constructor(
  /**
   * The parsed or programmatically created ES|QL AST. The AST is the only
   * required property for the query and is the source of truth for the query.
   */
  ast,
  /**
   * Optional source code that was used to generate the AST. Provide this
   * if the query was created from a parsed source code. Otherwise, set to
   * an empty string.
   */
  src = '',
  /**
   * Optional array of ANTLR tokens, in case the query was parsed from a
   * source code.
   */
  tokens = []) {
    this.ast = ast;
    this.src = src;
    this.tokens = tokens;
  }
  print(opts) {
    const printer = new _wrapping_pretty_printer.WrappingPrettyPrinter(opts);
    return printer.print(this.ast);
  }
}
exports.EsqlQuery = EsqlQuery;
_EsqlQuery = EsqlQuery;
(0, _defineProperty2.default)(EsqlQuery, "fromSrc", (src, opts) => {
  const {
    root,
    tokens
  } = (0, _parser.parse)(src, opts);
  return new _EsqlQuery(root, src, tokens);
});