"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WrappingPrettyPrinter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _helpers = require("../ast/helpers");
var _visitor = require("../visitor");
var _utils = require("../visitor/utils");
var _basic_pretty_printer = require("./basic_pretty_printer");
var _helpers2 = require("./helpers");
var _leaf_printer = require("./leaf_printer");
var _WrappingPrettyPrinter;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * @todo
 *
 * 1. Implement list literal pretty printing.
 */

class WrappingPrettyPrinter {
  constructor(_opts = {}) {
    var _opts$indent2, _opts$tab, _opts$pipeTab2, _opts$commandTab, _opts$multiline2, _opts$wrap, _opts$lowercase, _ref, _opts$lowercaseComman, _ref2, _opts$lowercaseOption, _ref3, _opts$lowercaseFuncti, _ref4, _opts$lowercaseKeywor;
    (0, _defineProperty2.default)(this, "opts", void 0);
    (0, _defineProperty2.default)(this, "visitor", new _visitor.Visitor().on('visitExpression', (ctx, inp) => {
      var _ctx$node$text;
      const txt = (_ctx$node$text = ctx.node.text) !== null && _ctx$node$text !== void 0 ? _ctx$node$text : '<EXPRESSION>';
      return {
        txt
      };
    }).on('visitSourceExpression', (ctx, inp) => {
      var _inp$suffix;
      const formatted = _leaf_printer.LeafPrinter.source(ctx.node) + ((_inp$suffix = inp.suffix) !== null && _inp$suffix !== void 0 ? _inp$suffix : '');
      const {
        txt,
        indented
      } = this.decorateWithComments(inp.indent, ctx.node, formatted);
      return {
        txt,
        indented
      };
    }).on('visitColumnExpression', (ctx, inp) => {
      var _inp$suffix2;
      const formatted = _leaf_printer.LeafPrinter.column(ctx.node) + ((_inp$suffix2 = inp.suffix) !== null && _inp$suffix2 !== void 0 ? _inp$suffix2 : '');
      const {
        txt,
        indented
      } = this.decorateWithComments(inp.indent, ctx.node, formatted);
      return {
        txt,
        indented
      };
    }).on('visitLiteralExpression', (ctx, inp) => {
      var _inp$suffix3;
      const formatted = _leaf_printer.LeafPrinter.literal(ctx.node) + ((_inp$suffix3 = inp.suffix) !== null && _inp$suffix3 !== void 0 ? _inp$suffix3 : '');
      const {
        txt,
        indented
      } = this.decorateWithComments(inp.indent, ctx.node, formatted);
      return {
        txt,
        indented
      };
    }).on('visitTimeIntervalLiteralExpression', (ctx, inp) => {
      var _inp$suffix4;
      const formatted = _leaf_printer.LeafPrinter.timeInterval(ctx.node) + ((_inp$suffix4 = inp.suffix) !== null && _inp$suffix4 !== void 0 ? _inp$suffix4 : '');
      const {
        txt,
        indented
      } = this.decorateWithComments(inp.indent, ctx.node, formatted);
      return {
        txt,
        indented
      };
    }).on('visitInlineCastExpression', (ctx, inp) => {
      var _inp$suffix5;
      const value = ctx.value();
      const wrapInBrackets = value.type !== 'literal' && value.type !== 'column' && !(value.type === 'function' && value.subtype === 'variadic-call');
      const castType = ctx.node.castType;
      let valueFormatted = ctx.visitValue({
        indent: inp.indent,
        remaining: inp.remaining - castType.length - 2
      }).txt;
      if (wrapInBrackets) {
        valueFormatted = `(${valueFormatted})`;
      }
      const formatted = `${valueFormatted}::${ctx.node.castType}${(_inp$suffix5 = inp.suffix) !== null && _inp$suffix5 !== void 0 ? _inp$suffix5 : ''}`;
      const {
        txt,
        indented
      } = this.decorateWithComments(inp.indent, ctx.node, formatted);
      return {
        txt,
        indented
      };
    }).on('visitRenameExpression', (ctx, inp) => {
      const operator = this.keyword('AS');
      const expression = this.visitBinaryExpression(ctx, operator, inp);
      const {
        txt,
        indented
      } = this.decorateWithComments(inp.indent, ctx.node, expression.txt, expression.indented);
      return {
        txt,
        indented
      };
    }).on('visitListLiteralExpression', (ctx, inp) => {
      var _inp$suffix6;
      const args = this.printArguments(ctx, {
        indent: inp.indent,
        remaining: inp.remaining - 1
      });
      const formatted = `[${args.txt}]${(_inp$suffix6 = inp.suffix) !== null && _inp$suffix6 !== void 0 ? _inp$suffix6 : ''}`;
      const {
        txt,
        indented
      } = this.decorateWithComments(inp.indent, ctx.node, formatted);
      return {
        txt,
        indented
      };
    }).on('visitFunctionCallExpression', (ctx, inp) => {
      var _this$opts$lowercaseF;
      const node = ctx.node;
      let operator = ctx.operator();
      let txt = '';
      if ((_this$opts$lowercaseF = this.opts.lowercaseFunctions) !== null && _this$opts$lowercaseF !== void 0 ? _this$opts$lowercaseF : this.opts.lowercase) {
        operator = operator.toLowerCase();
      }
      switch (node.subtype) {
        case 'unary-expression':
          {
            txt = `${operator} ${ctx.visitArgument(0, inp).txt}`;
            break;
          }
        case 'postfix-unary-expression':
          {
            var _inp$suffix7;
            const suffix = (_inp$suffix7 = inp.suffix) !== null && _inp$suffix7 !== void 0 ? _inp$suffix7 : '';
            txt = `${ctx.visitArgument(0, {
              ...inp,
              suffix: ''
            }).txt} ${operator}${suffix}`;
            break;
          }
        case 'binary-expression':
          {
            return this.visitBinaryExpression(ctx, operator, inp);
          }
        default:
          {
            var _inp$suffix8;
            const args = this.printArguments(ctx, {
              indent: inp.indent,
              remaining: inp.remaining - operator.length - 1
            });
            let breakClosingParenthesis = false;
            if ((0, _helpers2.getPrettyPrintStats)(ctx.node).hasRightSingleLineComments) {
              breakClosingParenthesis = true;
            }
            let closingParenthesisFormatted = ')';
            if (breakClosingParenthesis) {
              closingParenthesisFormatted = '\n' + inp.indent + ')';
            }
            txt = `${operator}(${args.txt}${closingParenthesisFormatted}${(_inp$suffix8 = inp.suffix) !== null && _inp$suffix8 !== void 0 ? _inp$suffix8 : ''}`;
          }
      }
      return {
        txt
      };
    }).on('visitCommandOption', (ctx, inp) => {
      const option = this.opts.lowercaseOptions ? ctx.node.name : ctx.node.name.toUpperCase();
      const args = this.printArguments(ctx, {
        indent: inp.indent,
        remaining: inp.remaining - option.length - 1
      });
      const argsFormatted = args.txt ? ` ${args.txt}` : '';
      const txt = `${option}${argsFormatted}`;
      return {
        txt,
        lines: args.lines
      };
    }).on('visitCommand', (ctx, inp) => {
      const opts = this.opts;
      const cmd = opts.lowercaseCommands ? ctx.node.name : ctx.node.name.toUpperCase();
      const args = this.printArguments(ctx, {
        indent: inp.indent,
        remaining: inp.remaining - cmd.length - 1
      });
      const optionIndent = args.indent + opts.pipeTab;
      const optionsTxt = [];
      let options = '';
      let optionsLines = 0;
      let breakOptions = false;
      for (const out of ctx.visitOptions({
        indent: optionIndent,
        remaining: opts.wrap - optionIndent.length
      })) {
        var _out$lines;
        optionsLines += (_out$lines = out.lines) !== null && _out$lines !== void 0 ? _out$lines : 1;
        optionsTxt.push(out.txt);
        options += (options ? ' ' : '') + out.txt;
      }
      breakOptions = breakOptions || args.lines > 1 || optionsLines > 1 || options.length > opts.wrap - inp.remaining - cmd.length - 1 - args.txt.length;
      if (breakOptions) {
        options = optionsTxt.join('\n' + optionIndent);
      }
      const argsWithWhitespace = args.txt ? `${args.oneArgumentPerLine ? '\n' : ' '}${args.txt}` : '';
      const optionsWithWhitespace = options ? `${breakOptions ? '\n' + optionIndent : ' '}${options}` : '';
      const txt = `${cmd}${argsWithWhitespace}${optionsWithWhitespace}`;
      return {
        txt,
        lines: args.lines /* add options lines count */
      };
    }).on('visitQuery', ctx => {
      var _opts$indent, _opts$multiline, _opts$pipeTab;
      const opts = this.opts;
      const indent = (_opts$indent = opts.indent) !== null && _opts$indent !== void 0 ? _opts$indent : '';
      const commands = ctx.node.commands;
      const commandCount = commands.length;
      let multiline = (_opts$multiline = opts.multiline) !== null && _opts$multiline !== void 0 ? _opts$multiline : commandCount > 3;
      if (!multiline) {
        const stats = (0, _helpers2.getPrettyPrintStats)(ctx.node);
        if (stats.hasLineBreakingDecorations) {
          multiline = true;
        }
      }
      if (!multiline) {
        const oneLine = indent + _basic_pretty_printer.BasicPrettyPrinter.print(ctx.node, opts);
        if (oneLine.length <= opts.wrap) {
          return oneLine;
        } else {
          multiline = true;
        }
      }
      let text = indent;
      const pipedCommandIndent = `${indent}${(_opts$pipeTab = opts.pipeTab) !== null && _opts$pipeTab !== void 0 ? _opts$pipeTab : '  '}`;
      const cmdSeparator = multiline ? `${pipedCommandIndent}| ` : ' | ';
      let i = 0;
      let prevOut;
      for (const out of ctx.visitCommands({
        indent,
        remaining: opts.wrap - indent.length
      })) {
        const isFirstCommand = i === 0;
        const isSecondCommand = i === 1;
        if (isSecondCommand) {
          var _prevOut;
          const firstCommandIsMultiline = ((_prevOut = prevOut) === null || _prevOut === void 0 ? void 0 : _prevOut.lines) && prevOut.lines > 1;
          if (firstCommandIsMultiline) text += '\n' + indent;
        }
        const commandIndent = isFirstCommand ? indent : pipedCommandIndent;
        const topDecorations = this.printTopDecorations(commandIndent, commands[i]);
        if (topDecorations) {
          if (!isFirstCommand) {
            text += '\n';
          }
          text += topDecorations;
        }
        if (!isFirstCommand) {
          if (multiline && !topDecorations) {
            text += '\n';
          }
          text += cmdSeparator;
        }
        text += out.txt;
        i++;
        prevOut = out;
      }
      return text;
    }));
    this.opts = {
      indent: (_opts$indent2 = _opts.indent) !== null && _opts$indent2 !== void 0 ? _opts$indent2 : '',
      tab: (_opts$tab = _opts.tab) !== null && _opts$tab !== void 0 ? _opts$tab : '  ',
      pipeTab: (_opts$pipeTab2 = _opts.pipeTab) !== null && _opts$pipeTab2 !== void 0 ? _opts$pipeTab2 : '  ',
      commandTab: (_opts$commandTab = _opts.commandTab) !== null && _opts$commandTab !== void 0 ? _opts$commandTab : '    ',
      multiline: (_opts$multiline2 = _opts.multiline) !== null && _opts$multiline2 !== void 0 ? _opts$multiline2 : false,
      wrap: (_opts$wrap = _opts.wrap) !== null && _opts$wrap !== void 0 ? _opts$wrap : 80,
      lowercase: (_opts$lowercase = _opts.lowercase) !== null && _opts$lowercase !== void 0 ? _opts$lowercase : false,
      lowercaseCommands: (_ref = (_opts$lowercaseComman = _opts.lowercaseCommands) !== null && _opts$lowercaseComman !== void 0 ? _opts$lowercaseComman : _opts.lowercase) !== null && _ref !== void 0 ? _ref : false,
      lowercaseOptions: (_ref2 = (_opts$lowercaseOption = _opts.lowercaseOptions) !== null && _opts$lowercaseOption !== void 0 ? _opts$lowercaseOption : _opts.lowercase) !== null && _ref2 !== void 0 ? _ref2 : false,
      lowercaseFunctions: (_ref3 = (_opts$lowercaseFuncti = _opts.lowercaseFunctions) !== null && _opts$lowercaseFuncti !== void 0 ? _opts$lowercaseFuncti : _opts.lowercase) !== null && _ref3 !== void 0 ? _ref3 : false,
      lowercaseKeywords: (_ref4 = (_opts$lowercaseKeywor = _opts.lowercaseKeywords) !== null && _opts$lowercaseKeywor !== void 0 ? _opts$lowercaseKeywor : _opts.lowercase) !== null && _ref4 !== void 0 ? _ref4 : false
    };
  }
  keyword(word) {
    var _this$opts$lowercaseK;
    return ((_this$opts$lowercaseK = this.opts.lowercaseKeywords) !== null && _this$opts$lowercaseK !== void 0 ? _this$opts$lowercaseK : this.opts.lowercase) ? word.toLowerCase() : word.toUpperCase();
  }
  visitBinaryExpression(ctx, operator, inp) {
    var _inp$suffix9;
    const node = ctx.node;
    const group = (0, _helpers.binaryExpressionGroup)(node);
    const [left, right] = ctx.arguments();
    const groupLeft = (0, _helpers.binaryExpressionGroup)(left);
    const groupRight = (0, _helpers.binaryExpressionGroup)(right);
    const continueVerticalFlattening = group && inp.flattenBinExpOfType === group;
    const suffix = (_inp$suffix9 = inp.suffix) !== null && _inp$suffix9 !== void 0 ? _inp$suffix9 : '';
    const oneArgumentPerLine = (0, _helpers2.getPrettyPrintStats)(left).hasLineBreakingDecorations || (0, _helpers2.getPrettyPrintStats)(right).hasLineBreakingDecorations;
    if (continueVerticalFlattening || oneArgumentPerLine) {
      var _ctx$parent;
      const parent = (_ctx$parent = ctx.parent) === null || _ctx$parent === void 0 ? void 0 : _ctx$parent.node;
      const isLeftChild = (0, _helpers.isBinaryExpression)(parent) && parent.args[0] === node;
      const leftInput = {
        indent: inp.indent,
        remaining: inp.remaining,
        flattenBinExpOfType: group
      };
      const rightTab = isLeftChild ? this.opts.tab : '';
      const rightIndent = inp.indent + rightTab + (oneArgumentPerLine ? this.opts.tab : '');
      const rightInput = {
        indent: rightIndent,
        remaining: inp.remaining - this.opts.tab.length,
        flattenBinExpOfType: group
      };
      const leftOut = ctx.visitArgument(0, leftInput);
      const rightOut = ctx.visitArgument(1, rightInput);
      let txt = `${leftOut.txt} ${operator}\n`;
      if (!rightOut.indented) {
        txt += rightIndent;
      }
      txt += rightOut.txt + suffix;
      return {
        txt,
        indented: leftOut.indented
      };
    }
    let txt = '';
    let leftFormatted = _basic_pretty_printer.BasicPrettyPrinter.expression(left, this.opts);
    let rightFormatted = _basic_pretty_printer.BasicPrettyPrinter.expression(right, this.opts);
    if (groupLeft && groupLeft < group) {
      leftFormatted = `(${leftFormatted})`;
    }
    if (groupRight && groupRight < group) {
      rightFormatted = `(${rightFormatted})`;
    }
    const length = leftFormatted.length + rightFormatted.length + operator.length + 2;
    const fitsOnOneLine = length <= inp.remaining;
    let indented = false;
    if (fitsOnOneLine) {
      txt = `${leftFormatted} ${operator} ${rightFormatted}${suffix}`;
    } else {
      const flattenVertically = group === groupLeft || group === groupRight;
      const flattenBinExpOfType = flattenVertically ? group : undefined;
      const leftInput = {
        indent: inp.indent,
        remaining: inp.remaining,
        flattenBinExpOfType
      };
      const rightInput = {
        indent: inp.indent + this.opts.tab,
        remaining: inp.remaining - this.opts.tab.length,
        flattenBinExpOfType
      };
      const leftOut = ctx.visitArgument(0, leftInput);
      const rightOut = ctx.visitArgument(1, rightInput);
      txt = `${leftOut.txt} ${operator}\n`;
      if (!rightOut.indented) {
        txt += `${inp.indent}${this.opts.tab}`;
      }
      txt += `${rightOut.txt}${suffix}`;
      indented = leftOut.indented;
    }
    return {
      txt,
      indented
    };
  }
  printArguments(ctx, inp) {
    let txt = '';
    let lines = 1;
    let largestArg = 0;
    let argsPerLine = 0;
    let minArgsPerLine = 1e6;
    let maxArgsPerLine = 0;
    let remainingCurrentLine = inp.remaining;
    let oneArgumentPerLine = false;
    for (const child of (0, _utils.children)(ctx.node)) {
      if ((0, _helpers2.getPrettyPrintStats)(child).hasLineBreakingDecorations) {
        oneArgumentPerLine = true;
        break;
      }
    }
    if (!oneArgumentPerLine) {
      ARGS: for (const arg of (0, _utils.singleItems)(ctx.arguments())) {
        if (arg.type === 'option') {
          continue;
        }
        const formattedArg = _basic_pretty_printer.BasicPrettyPrinter.expression(arg, this.opts);
        const formattedArgLength = formattedArg.length;
        const needsWrap = remainingCurrentLine < formattedArgLength;
        if (formattedArgLength > largestArg) {
          largestArg = formattedArgLength;
        }
        let separator = txt ? ',' : '';
        let fragment = '';
        if (needsWrap) {
          separator += '\n' + inp.indent + this.opts.tab + (ctx instanceof _visitor.CommandVisitorContext ? this.opts.commandTab : '');
          fragment = separator + formattedArg;
          lines++;
          if (argsPerLine > maxArgsPerLine) {
            maxArgsPerLine = argsPerLine;
          }
          if (argsPerLine < minArgsPerLine) {
            minArgsPerLine = argsPerLine;
            if (minArgsPerLine < 2) {
              oneArgumentPerLine = true;
              break ARGS;
            }
          }
          remainingCurrentLine = inp.remaining - formattedArgLength - this.opts.tab.length - this.opts.commandTab.length;
          argsPerLine = 1;
        } else {
          argsPerLine++;
          fragment = separator + (separator ? ' ' : '') + formattedArg;
          remainingCurrentLine -= fragment.length;
        }
        txt += fragment;
      }
    }
    let indent = inp.indent + this.opts.tab;
    if (ctx instanceof _visitor.CommandVisitorContext) {
      var _ctx$parent2, _ctx$parent2$node, _ctx$parent2$node$com;
      const isFirstCommand = ((_ctx$parent2 = ctx.parent) === null || _ctx$parent2 === void 0 ? void 0 : (_ctx$parent2$node = _ctx$parent2.node) === null || _ctx$parent2$node === void 0 ? void 0 : (_ctx$parent2$node$com = _ctx$parent2$node.commands) === null || _ctx$parent2$node$com === void 0 ? void 0 : _ctx$parent2$node$com[0]) === ctx.node;
      if (!isFirstCommand) {
        indent += this.opts.commandTab;
      }
    }
    if (oneArgumentPerLine) {
      lines = 1;
      txt = ctx instanceof _visitor.CommandVisitorContext ? '' : '\n';
      const args = [...ctx.arguments()].filter(arg => {
        if (arg.type === 'option') return arg.name === 'as';
        return true;
      });
      const length = args.length;
      const last = length - 1;
      for (let i = 0; i <= last; i++) {
        const isFirstArg = i === 0;
        const isLastArg = i === last;
        const arg = ctx.visitExpression(args[i], {
          indent,
          remaining: this.opts.wrap - indent.length,
          suffix: isLastArg ? '' : ','
        });
        const separator = isFirstArg ? '' : '\n';
        const indentation = arg.indented ? '' : indent;
        txt += separator + indentation + arg.txt;
        lines++;
      }
    }
    return {
      txt,
      lines,
      indent,
      oneArgumentPerLine
    };
  }
  printTopDecorations(indent, node) {
    const formatting = node.formatting;
    if (!formatting || !formatting.top || !formatting.top.length) {
      return '';
    }
    let txt = '';
    for (const decoration of formatting.top) {
      if (decoration.type === 'comment') {
        txt += indent + _leaf_printer.LeafPrinter.comment(decoration) + '\n';
      }
    }
    return txt;
  }
  decorateWithComments(indent, node, txt, indented = false) {
    const formatting = node.formatting;
    if (!formatting) {
      return {
        txt,
        indented
      };
    }
    if (formatting.left) {
      const comments = _leaf_printer.LeafPrinter.commentList(formatting.left);
      if (comments) {
        indented = true;
        txt = `${indent}${comments} ${txt}`;
      }
    }
    if (formatting.top) {
      const top = formatting.top;
      const length = top.length;
      for (let i = length - 1; i >= 0; i--) {
        const decoration = top[i];
        if (decoration.type === 'comment') {
          if (!indented) {
            txt = indent + txt;
            indented = true;
          }
          txt = indent + _leaf_printer.LeafPrinter.comment(decoration) + '\n' + txt;
        }
      }
    }
    if (formatting.right) {
      const comments = _leaf_printer.LeafPrinter.commentList(formatting.right);
      if (comments) {
        txt = `${txt} ${comments}`;
      }
    }
    if (formatting.rightSingleLine) {
      const comment = _leaf_printer.LeafPrinter.comment(formatting.rightSingleLine);
      txt += ` ${comment}`;
    }
    if (formatting.bottom) {
      for (const decoration of formatting.bottom) {
        if (decoration.type === 'comment') {
          indented = true;
          txt = txt + '\n' + indent + _leaf_printer.LeafPrinter.comment(decoration);
        }
      }
    }
    return {
      txt,
      indented
    };
  }
  print(query) {
    return this.visitor.visitQuery(query);
  }
}
exports.WrappingPrettyPrinter = WrappingPrettyPrinter;
_WrappingPrettyPrinter = WrappingPrettyPrinter;
(0, _defineProperty2.default)(WrappingPrettyPrinter, "print", (query, opts) => {
  const printer = new _WrappingPrettyPrinter(opts);
  return printer.print(query);
});