"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicPrettyPrinter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _helpers = require("../ast/helpers");
var _visitor = require("../visitor");
var _leaf_printer = require("./leaf_printer");
var _BasicPrettyPrinter;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class BasicPrettyPrinter {
  constructor(_opts = {}) {
    var _opts$pipeTab2, _opts$multiline, _opts$lowercase, _ref, _opts$lowercaseComman, _ref2, _opts$lowercaseOption, _ref3, _opts$lowercaseFuncti, _ref4, _opts$lowercaseKeywor;
    (0, _defineProperty2.default)(this, "opts", void 0);
    (0, _defineProperty2.default)(this, "visitor", new _visitor.Visitor().on('visitExpression', ctx => {
      return '<EXPRESSION>';
    }).on('visitSourceExpression', ctx => {
      const formatted = _leaf_printer.LeafPrinter.source(ctx.node);
      return this.decorateWithComments(ctx.node, formatted);
    }).on('visitColumnExpression', ctx => {
      const formatted = _leaf_printer.LeafPrinter.column(ctx.node);
      return this.decorateWithComments(ctx.node, formatted);
    }).on('visitLiteralExpression', ctx => {
      const formatted = _leaf_printer.LeafPrinter.literal(ctx.node);
      return this.decorateWithComments(ctx.node, formatted);
    }).on('visitTimeIntervalLiteralExpression', ctx => {
      const formatted = _leaf_printer.LeafPrinter.timeInterval(ctx.node);
      return this.decorateWithComments(ctx.node, formatted);
    }).on('visitInlineCastExpression', ctx => {
      const value = ctx.value();
      const wrapInBrackets = value.type !== 'literal' && value.type !== 'column' && !(value.type === 'function' && value.subtype === 'variadic-call');
      let valueFormatted = ctx.visitValue();
      if (wrapInBrackets) {
        valueFormatted = `(${valueFormatted})`;
      }
      const typeName = this.keyword(ctx.node.castType);
      const formatted = `${valueFormatted}::${typeName}`;
      return this.decorateWithComments(ctx.node, formatted);
    }).on('visitListLiteralExpression', ctx => {
      let elements = '';
      for (const arg of ctx.visitElements()) {
        elements += (elements ? ', ' : '') + arg;
      }
      const formatted = `[${elements}]`;
      return this.decorateWithComments(ctx.node, formatted);
    }).on('visitFunctionCallExpression', ctx => {
      const opts = this.opts;
      const node = ctx.node;
      let operator = ctx.operator();
      switch (node.subtype) {
        case 'unary-expression':
          {
            operator = this.keyword(operator);
            const formatted = `${operator} ${ctx.visitArgument(0, undefined)}`;
            return this.decorateWithComments(ctx.node, formatted);
          }
        case 'postfix-unary-expression':
          {
            operator = this.keyword(operator);
            const formatted = `${ctx.visitArgument(0)} ${operator}`;
            return this.decorateWithComments(ctx.node, formatted);
          }
        case 'binary-expression':
          {
            operator = this.keyword(operator);
            const group = (0, _helpers.binaryExpressionGroup)(ctx.node);
            const [left, right] = ctx.arguments();
            const groupLeft = (0, _helpers.binaryExpressionGroup)(left);
            const groupRight = (0, _helpers.binaryExpressionGroup)(right);
            let leftFormatted = ctx.visitArgument(0);
            let rightFormatted = ctx.visitArgument(1);
            if (groupLeft && groupLeft < group) {
              leftFormatted = `(${leftFormatted})`;
            }
            if (groupRight && groupRight < group) {
              rightFormatted = `(${rightFormatted})`;
            }
            const formatted = `${leftFormatted} ${operator} ${rightFormatted}`;
            return this.decorateWithComments(ctx.node, formatted);
          }
        default:
          {
            if (opts.lowercaseFunctions) {
              operator = operator.toLowerCase();
            }
            let args = '';
            for (const arg of ctx.visitArguments()) {
              args += (args ? ', ' : '') + arg;
            }
            const formatted = `${operator}(${args})`;
            return this.decorateWithComments(ctx.node, formatted);
          }
      }
    }).on('visitRenameExpression', ctx => {
      const formatted = `${ctx.visitArgument(0)} ${this.keyword('AS')} ${ctx.visitArgument(1)}`;
      return this.decorateWithComments(ctx.node, formatted);
    }).on('visitOrderExpression', ctx => {
      const node = ctx.node;
      let text = ctx.visitArgument(0);
      if (node.order) {
        text += ` ${node.order}`;
      }
      if (node.nulls) {
        text += ` ${node.nulls}`;
      }
      return text;
    }).on('visitCommandOption', ctx => {
      const opts = this.opts;
      const option = opts.lowercaseOptions ? ctx.node.name : ctx.node.name.toUpperCase();
      let args = '';
      for (const arg of ctx.visitArguments()) {
        args += (args ? ', ' : '') + arg;
      }
      const argsFormatted = args ? ` ${args}` : '';
      const optionFormatted = `${option}${argsFormatted}`;
      return optionFormatted;
    }).on('visitCommand', ctx => {
      const opts = this.opts;
      const cmd = opts.lowercaseCommands ? ctx.node.name : ctx.node.name.toUpperCase();
      let args = '';
      let options = '';
      for (const source of ctx.visitArguments()) {
        args += (args ? ', ' : '') + source;
      }
      for (const option of ctx.visitOptions()) {
        options += (options ? ' ' : '') + option;
      }
      const argsFormatted = args ? ` ${args}` : '';
      const optionsFormatted = options ? ` ${options}` : '';
      const cmdFormatted = `${cmd}${argsFormatted}${optionsFormatted}`;
      return cmdFormatted;
    }).on('visitQuery', ctx => {
      var _opts$pipeTab;
      const opts = this.opts;
      const cmdSeparator = opts.multiline ? `\n${(_opts$pipeTab = opts.pipeTab) !== null && _opts$pipeTab !== void 0 ? _opts$pipeTab : '  '}| ` : ' | ';
      let text = '';
      for (const cmd of ctx.visitCommands()) {
        if (text) text += cmdSeparator;
        text += cmd;
      }
      return text;
    }));
    this.opts = {
      pipeTab: (_opts$pipeTab2 = _opts.pipeTab) !== null && _opts$pipeTab2 !== void 0 ? _opts$pipeTab2 : '  ',
      multiline: (_opts$multiline = _opts.multiline) !== null && _opts$multiline !== void 0 ? _opts$multiline : false,
      lowercase: (_opts$lowercase = _opts.lowercase) !== null && _opts$lowercase !== void 0 ? _opts$lowercase : false,
      lowercaseCommands: (_ref = (_opts$lowercaseComman = _opts.lowercaseCommands) !== null && _opts$lowercaseComman !== void 0 ? _opts$lowercaseComman : _opts.lowercase) !== null && _ref !== void 0 ? _ref : false,
      lowercaseOptions: (_ref2 = (_opts$lowercaseOption = _opts.lowercaseOptions) !== null && _opts$lowercaseOption !== void 0 ? _opts$lowercaseOption : _opts.lowercase) !== null && _ref2 !== void 0 ? _ref2 : false,
      lowercaseFunctions: (_ref3 = (_opts$lowercaseFuncti = _opts.lowercaseFunctions) !== null && _opts$lowercaseFuncti !== void 0 ? _opts$lowercaseFuncti : _opts.lowercase) !== null && _ref3 !== void 0 ? _ref3 : false,
      lowercaseKeywords: (_ref4 = (_opts$lowercaseKeywor = _opts.lowercaseKeywords) !== null && _opts$lowercaseKeywor !== void 0 ? _opts$lowercaseKeywor : _opts.lowercase) !== null && _ref4 !== void 0 ? _ref4 : false
    };
  }
  keyword(word) {
    var _this$opts$lowercaseK;
    return ((_this$opts$lowercaseK = this.opts.lowercaseKeywords) !== null && _this$opts$lowercaseK !== void 0 ? _this$opts$lowercaseK : this.opts.lowercase) ? word.toLowerCase() : word.toUpperCase();
  }
  decorateWithComments(node, formatted) {
    const formatting = node.formatting;
    if (!formatting) {
      return formatted;
    }
    if (formatting.left) {
      const comments = _leaf_printer.LeafPrinter.commentList(formatting.left);
      if (comments) {
        formatted = `${comments} ${formatted}`;
      }
    }
    if (formatting.right) {
      const comments = _leaf_printer.LeafPrinter.commentList(formatting.right);
      if (comments) {
        formatted = `${formatted} ${comments}`;
      }
    }
    return formatted;
  }
  print(query) {
    return this.visitor.visitQuery(query, undefined);
  }
  printCommand(command) {
    return this.visitor.visitCommand(command, undefined);
  }
  printExpression(expression) {
    return this.visitor.visitExpression(expression, undefined);
  }
}
exports.BasicPrettyPrinter = BasicPrettyPrinter;
_BasicPrettyPrinter = BasicPrettyPrinter;
/**
 * @param query ES|QL query AST to print.
 * @returns A single-line string representation of the query.
 */
(0, _defineProperty2.default)(BasicPrettyPrinter, "print", (query, opts) => {
  const printer = new _BasicPrettyPrinter(opts);
  return printer.print(query);
});
/**
 * Print a query with each command on a separate line. It is also possible to
 * specify a tabbing option for the pipe character.
 *
 * @param query ES|QL query AST to print.
 * @param opts Options for pretty-printing.
 * @returns A multi-line string representation of the query.
 */
(0, _defineProperty2.default)(BasicPrettyPrinter, "multiline", (query, opts) => {
  const printer = new _BasicPrettyPrinter({
    ...opts,
    multiline: true
  });
  return printer.print(query);
});
/**
 * @param command ES|QL command AST node to print.
 * @returns Prints a single-line string representation of the command.
 */
(0, _defineProperty2.default)(BasicPrettyPrinter, "command", (command, opts) => {
  const printer = new _BasicPrettyPrinter(opts);
  return printer.printCommand(command);
});
/**
 * @param expression ES|QL expression AST node to print.
 * @returns Prints a single-line string representation of the expression.
 */
(0, _defineProperty2.default)(BasicPrettyPrinter, "expression", (expression, opts) => {
  const printer = new _BasicPrettyPrinter(opts);
  return printer.printExpression(expression);
});