"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsert = exports.remove = exports.list = exports.insert = exports.findByPredicate = exports.find = void 0;
var _builder = require("../../../builder");
var _visitor = require("../../../visitor");
var generic = _interopRequireWildcard(require("../../generic"));
var util = _interopRequireWildcard(require("../../util"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const list = ast => {
  return new _visitor.Visitor().on('visitFromCommand', function* (ctx) {
    for (const argument of ctx.arguments()) {
      if (argument.type === 'source') {
        yield argument;
      }
    }
  }).on('visitCommand', function* () {}).on('visitQuery', function* (ctx) {
    for (const command of ctx.visitCommands()) {
      yield* command;
    }
  }).visitQuery(ast);
};
exports.list = list;
const findByPredicate = (ast, predicate) => {
  return util.findByPredicate(list(ast), predicate);
};
exports.findByPredicate = findByPredicate;
const find = (ast, index, cluster) => {
  return findByPredicate(ast, source => {
    if (index !== source.index) {
      return false;
    }
    if (typeof cluster === 'string' && cluster !== source.cluster) {
      return false;
    }
    return true;
  });
};
exports.find = find;
const remove = (ast, index, cluster) => {
  const node = find(ast, index, cluster);
  if (!node) {
    return undefined;
  }
  const success = generic.removeCommandArgument(ast, node);
  return success ? node : undefined;
};
exports.remove = remove;
const insert = (ast, indexName, clusterName, index = -1) => {
  const command = generic.findCommandByName(ast, 'from');
  if (!command) {
    return;
  }
  const source = _builder.Builder.expression.indexSource(indexName, clusterName);
  if (index === -1) {
    generic.appendCommandArgument(command, source);
  } else {
    command.args.splice(index, 0, source);
  }
  return source;
};
exports.insert = insert;
const upsert = (ast, indexName, clusterName, index = -1) => {
  const source = find(ast, indexName, clusterName);
  if (source) {
    return source;
  }
  return insert(ast, indexName, clusterName, index);
};
exports.upsert = upsert;