"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Builder = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/* eslint-disable @typescript-eslint/no-namespace */
let Builder = exports.Builder = void 0;
(function (_Builder) {
  const parserFields = _Builder.parserFields = ({
    location = {
      min: 0,
      max: 0
    },
    text = '',
    incomplete = false
  } = {}) => ({
    location,
    text,
    incomplete
  });
  const command = _Builder.command = (template, fromParser) => {
    var _template$args;
    return {
      ...template,
      ...Builder.parserFields(fromParser),
      args: (_template$args = template.args) !== null && _template$args !== void 0 ? _template$args : [],
      type: 'command'
    };
  };
  const option = _Builder.option = (template, fromParser) => {
    var _template$args2;
    return {
      ...template,
      ...Builder.parserFields(fromParser),
      args: (_template$args2 = template.args) !== null && _template$args2 !== void 0 ? _template$args2 : [],
      type: 'option'
    };
  };
  const comment = _Builder.comment = (subtype, text, location) => {
    return {
      type: 'comment',
      subtype,
      text,
      location
    };
  };
  let expression;
  (function (_expression) {
    const query = _expression.query = (commands = [], fromParser) => {
      return {
        ...Builder.parserFields(fromParser),
        commands,
        type: 'query',
        name: ''
      };
    };
    const source = _expression.source = (template, fromParser) => {
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        type: 'source'
      };
    };
    const indexSource = _expression.indexSource = (index, cluster, template, fromParser) => {
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        index,
        cluster,
        name: (cluster ? cluster + ':' : '') + index,
        sourceType: 'index',
        type: 'source'
      };
    };
    const column = _expression.column = (template, fromParser) => {
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        quoted: false,
        name: template.parts.join('.'),
        type: 'column'
      };
    };
    const inlineCast = _expression.inlineCast = (template, fromParser) => {
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        type: 'inlineCast',
        name: ''
      };
    };
    let literal;
    (function (_literal) {
      const numeric = _literal.numeric = (template, fromParser) => {
        const node = {
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'literal',
          name: template.value.toString()
        };
        return node;
      };
      const list = _literal.list = (template, fromParser) => {
        return {
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'list',
          name: ''
        };
      };
    })(literal || (literal = _expression.literal || (_expression.literal = {})));
  })(expression || (expression = _Builder.expression || (_Builder.expression = {})));
})(Builder || (exports.Builder = Builder = {}));