"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityDefinitionRoute = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
var _zod = require("@kbn/zod");
var _create_entity_manager_server_route = require("../create_entity_manager_server_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @openapi
 * /internal/entities/definition:
 *   get:
 *     description: Get all installed entity definitions.
 *     tags:
 *       - definitions
 *     parameters:
 *       - in: path
 *         name: id
 *         description: The entity definition ID
 *         schema:
 *           $ref: '#/components/schemas/deleteEntityDefinitionParamsSchema/properties/id'
 *         required: false
 *       - in: query
 *         name: page
 *         schema:
 *           $ref: '#/components/schemas/getEntityDefinitionQuerySchema/properties/page'
 *       - in: query
 *         name: perPage
 *         schema:
 *           $ref: '#/components/schemas/getEntityDefinitionQuerySchema/properties/perPage'
 *       - in: query
 *         name: includeState
 *         schema:
 *           $ref: '#/components/schemas/getEntityDefinitionQuerySchema/properties/includeState'
 *     responses:
 *       200:
 *         description: OK
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 definitions:
 *                   type: array
 *                   items:
 *                     allOf:
 *                       - $ref: '#/components/schemas/entityDefinitionSchema'
 */
const getEntityDefinitionRoute = exports.getEntityDefinitionRoute = (0, _create_entity_manager_server_route.createEntityManagerServerRoute)({
  endpoint: 'GET /internal/entities/definition/{id?}',
  params: _zod.z.object({
    query: _entitiesSchema.getEntityDefinitionQuerySchema,
    path: _zod.z.object({
      id: _zod.z.optional(_zod.z.string())
    })
  }),
  handler: async ({
    request,
    response,
    params,
    logger,
    getScopedClient
  }) => {
    try {
      var _params$path;
      const client = await getScopedClient({
        request
      });
      const result = await client.getEntityDefinitions({
        id: (_params$path = params.path) === null || _params$path === void 0 ? void 0 : _params$path.id,
        page: params.query.page,
        perPage: params.query.perPage,
        includeState: params.query.includeState
      });
      return response.ok({
        body: result
      });
    } catch (e) {
      logger.error(e);
      return response.customError({
        body: e,
        statusCode: 500
      });
    }
  }
});