"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.EntityManagerServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverRouteRepository = require("@kbn/server-route-repository");
var _rxjs = require("rxjs");
var _config = require("../common/config");
var _built_in = require("./lib/entities/built_in");
var _upgrade_entity_definition = require("./lib/entities/upgrade_entity_definition");
var _entity_client = require("./lib/entity_client");
var _manage_index_templates = require("./lib/manage_index_templates");
var _routes = require("./routes");
var _saved_objects = require("./saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

const config = exports.config = {
  schema: _config.configSchema,
  exposeToBrowser: _config.exposeToBrowserConfig
};
class EntityManagerServerPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    this.config = context.config.get();
    this.logger = context.logger.get();
  }
  setup(core, plugins) {
    core.savedObjects.registerType(_saved_objects.entityDefinition);
    core.savedObjects.registerType(_saved_objects.EntityDiscoveryApiKeyType);
    plugins.encryptedSavedObjects.registerType({
      type: _saved_objects.EntityDiscoveryApiKeyType.name,
      attributesToEncrypt: new Set(['apiKey']),
      attributesToIncludeInAAD: new Set(['id', 'name'])
    });
    this.server = {
      config: this.config,
      logger: this.logger
    };
    (0, _serverRouteRepository.registerRoutes)({
      repository: _routes.entityManagerRouteRepository,
      dependencies: {
        server: this.server,
        getScopedClient: async ({
          request
        }) => {
          const [coreStart] = await core.getStartServices();
          return this.getScopedClient({
            request,
            coreStart
          });
        }
      },
      core,
      logger: this.logger
    });
    return {};
  }
  async getScopedClient({
    request,
    coreStart
  }) {
    const clusterClient = coreStart.elasticsearch.client.asScoped(request);
    const soClient = coreStart.savedObjects.getScopedClient(request);
    return new _entity_client.EntityClient({
      clusterClient,
      soClient,
      logger: this.logger
    });
  }
  start(core, plugins) {
    if (this.server) {
      this.server.core = core;
      this.server.isServerless = core.elasticsearch.getCapabilities().serverless;
      this.server.security = plugins.security;
      this.server.encryptedSavedObjects = plugins.encryptedSavedObjects;
    }
    const esClient = core.elasticsearch.client.asInternalUser;
    (0, _manage_index_templates.installEntityManagerTemplates)({
      esClient,
      logger: this.logger
    }).then(async () => {
      // the api key validation requires a check against the cluster license
      // which is lazily loaded. we ensure it gets loaded before the update
      await (0, _rxjs.firstValueFrom)(plugins.licensing.license$);
      const {
        success
      } = await (0, _upgrade_entity_definition.upgradeBuiltInEntityDefinitions)({
        definitions: _built_in.builtInDefinitions,
        server: this.server
      });
      if (success) {
        this.logger.info('Builtin definitions were successfully upgraded');
      }
    }).catch(err => this.logger.error(err));
    return {
      getScopedClient: async ({
        request
      }) => {
        return this.getScopedClient({
          request,
          coreStart: core
        });
      }
    };
  }
  stop() {}
}
exports.EntityManagerServerPlugin = EntityManagerServerPlugin;