"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClientsFromAPIKey = void 0;
var _fake_kibana_request = require("@kbn/security-plugin/server/authentication/api_keys/fake_kibana_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getClientsFromAPIKey = ({
  apiKey,
  server
}) => {
  const fakeRequest = (0, _fake_kibana_request.getFakeKibanaRequest)({
    id: apiKey.id,
    api_key: apiKey.apiKey
  });
  const clusterClient = server.core.elasticsearch.client.asScoped(fakeRequest);
  const soClient = server.core.savedObjects.getScopedClient(fakeRequest);
  return {
    clusterClient,
    soClient
  };
};
exports.getClientsFromAPIKey = getClientsFromAPIKey;