"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteIndices = deleteIndices;
var _generate_component_id = require("./helpers/generate_component_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteIndices(esClient, definition, logger) {
  const index = (0, _generate_component_id.generateLatestIndexName)(definition);
  try {
    await esClient.indices.delete({
      index,
      ignore_unavailable: true
    });
  } catch (e) {
    logger.error(`Unable to remove entity definition index ${index} for definition [${definition.id}]`);
    throw e;
  }
}