"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityManagerClient = void 0;
var _find_entity_definition = require("../entities/find_entity_definition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EntityManagerClient {
  constructor(esClient, soClient) {
    this.esClient = esClient;
    this.soClient = soClient;
  }
  findEntityDefinitions({
    page,
    perPage
  } = {}) {
    return (0, _find_entity_definition.findEntityDefinitions)({
      esClient: this.esClient.asCurrentUser,
      soClient: this.soClient,
      page,
      perPage
    });
  }
}
exports.EntityManagerClient = EntityManagerClient;