"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveEntityDiscoveryAPIKey = exports.readEntityDiscoveryAPIKey = exports.deleteEntityDiscoveryAPIKey = void 0;
var _server = require("@kbn/core/server");
var _saved_objects = require("../../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_DISCOVERY_API_KEY_SO_ID = '19540C97-E35C-485B-8566-FB86EC8455E4';
const getEncryptedSOClient = server => {
  return server.encryptedSavedObjects.getClient({
    includedHiddenTypes: [_saved_objects.EntityDiscoveryApiKeyType.name]
  });
};
const readEntityDiscoveryAPIKey = async server => {
  try {
    const soClient = getEncryptedSOClient(server);
    const obj = await soClient.getDecryptedAsInternalUser(_saved_objects.EntityDiscoveryApiKeyType.name, ENTITY_DISCOVERY_API_KEY_SO_ID);
    return obj === null || obj === void 0 ? void 0 : obj.attributes;
  } catch (err) {
    if (_server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
      return undefined;
    }
    throw err;
  }
};
exports.readEntityDiscoveryAPIKey = readEntityDiscoveryAPIKey;
const saveEntityDiscoveryAPIKey = async (soClient, apiKey) => {
  await soClient.create(_saved_objects.EntityDiscoveryApiKeyType.name, apiKey, {
    id: ENTITY_DISCOVERY_API_KEY_SO_ID,
    overwrite: true,
    managed: true
  });
};
exports.saveEntityDiscoveryAPIKey = saveEntityDiscoveryAPIKey;
const deleteEntityDiscoveryAPIKey = async soClient => {
  await soClient.delete(_saved_objects.EntityDiscoveryApiKeyType.name, ENTITY_DISCOVERY_API_KEY_SO_ID);
};
exports.deleteEntityDiscoveryAPIKey = deleteEntityDiscoveryAPIKey;