"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _errors = require("./errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EntityClient {
  constructor(core) {
    (0, _defineProperty2.default)(this, "repositoryClient", void 0);
    this.repositoryClient = (0, _serverRouteRepositoryClient.createRepositoryClient)(core).fetch;
  }
  async isManagedEntityDiscoveryEnabled() {
    return await this.repositoryClient('GET /internal/entities/managed/enablement');
  }
  async enableManagedEntityDiscovery(query) {
    try {
      return await this.repositoryClient('PUT /internal/entities/managed/enablement', {
        params: {
          query: {
            installOnly: query === null || query === void 0 ? void 0 : query.installOnly
          }
        }
      });
    } catch (err) {
      var _err$body;
      if ((0, _serverRouteRepositoryClient.isHttpFetchError)(err) && ((_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.statusCode) === 403) {
        throw new _errors.EntityManagerUnauthorizedError(err.body.message);
      }
      throw err;
    }
  }
  async disableManagedEntityDiscovery(query) {
    try {
      return await this.repositoryClient('DELETE /internal/entities/managed/enablement', {
        params: {
          query: {
            deleteData: query === null || query === void 0 ? void 0 : query.deleteData
          }
        }
      });
    } catch (err) {
      var _err$body2;
      if ((0, _serverRouteRepositoryClient.isHttpFetchError)(err) && ((_err$body2 = err.body) === null || _err$body2 === void 0 ? void 0 : _err$body2.statusCode) === 403) {
        throw new _errors.EntityManagerUnauthorizedError(err.body.message);
      }
      throw err;
    }
  }
}
exports.EntityClient = EntityClient;