"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityMetadataSchema = exports.entityLatestSchema = exports.entityBaseSchema = void 0;
var _zod = require("@kbn/zod");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityBaseSchema = exports.entityBaseSchema = _zod.z.object({
  id: _zod.z.string(),
  type: _zod.z.string(),
  identity_fields: _common.arrayOfStringsSchema,
  display_name: _zod.z.string(),
  metrics: _zod.z.record(_zod.z.string(), _zod.z.number()),
  definition_version: _zod.z.string(),
  schema_version: _zod.z.string(),
  definition_id: _zod.z.string()
});
const literalSchema = _zod.z.union([_zod.z.string(), _zod.z.number(), _zod.z.boolean(), _zod.z.null()]);
const entityMetadataSchema = exports.entityMetadataSchema = _zod.z.lazy(() => _zod.z.union([literalSchema, _zod.z.array(entityMetadataSchema), _zod.z.record(entityMetadataSchema)]));
const entityLatestSchema = exports.entityLatestSchema = _zod.z.object({
  entity: entityBaseSchema.merge(_zod.z.object({
    last_seen_timestamp: _zod.z.string()
  }))
}).and(entityMetadataSchema);