"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewLogic = exports.OverviewLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'workplace_search', 'overview_logic'],
  actions: {
    setServerData: serverData => serverData,
    initializeOverview: () => null
  },
  reducers: {
    hasUsers: [false, {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerData: (_, {
        hasUsers
      }) => hasUsers
    }],
    hasOrgSources: [false, {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerData: (_, {
        hasOrgSources
      }) => hasOrgSources
    }],
    isOldAccount: [false, {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerData: (_, {
        isOldAccount
      }) => isOldAccount
    }],
    sourcesCount: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerData: (_, {
        sourcesCount
      }) => sourcesCount
    }],
    pendingInvitationsCount: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerData: (_, {
        pendingInvitationsCount
      }) => pendingInvitationsCount
    }],
    accountsCount: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerData: (_, {
        accountsCount
      }) => accountsCount
    }],
    privateSourcesCount: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerData: (_, {
        privateSourcesCount
      }) => privateSourcesCount
    }],
    activityFeed: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      setServerData: (_, {
        activityFeed
      }) => activityFeed
    }],
    dataLoading: [true, {
      setServerData: () => false
    }]
  },
  listeners: ({
    actions
  }) => ({
    initializeOverview: async () => {
      try {
        const response = await _http.HttpLogic.values.http.get('/internal/workplace_search/overview');
        actions.setServerData(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});