"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_NAME_LENGTH = exports.GroupsLogic = void 0;
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _constants2 = require("../../../shared/constants");
var _flash_messages = require("../../../shared/flash_messages");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_NAME_LENGTH = exports.MAX_NAME_LENGTH = 40;
const GroupsLogic = exports.GroupsLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'workplace_search', 'groups'],
  actions: {
    onInitializeGroups: data => data,
    setSearchResults: data => data,
    addFilteredSource: sourceId => sourceId,
    removeFilteredSource: sourceId => sourceId,
    setFilterValue: filterValue => filterValue,
    setActivePage: activePage => activePage,
    setNewGroupName: newGroupName => newGroupName,
    setNewGroup: newGroup => newGroup,
    setNewGroupFormErrors: errors => errors,
    openNewGroupModal: () => true,
    closeNewGroupModal: () => true,
    closeFilterSourcesDropdown: () => true,
    toggleFilterSourcesDropdown: () => true,
    setGroupsLoading: () => true,
    resetGroupsFilters: () => true,
    resetGroups: () => true,
    initializeGroups: () => true,
    getSearchResults: resetPagination => ({
      resetPagination
    }),
    saveNewGroup: () => true
  },
  reducers: {
    groups: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      setSearchResults: (_, {
        results
      }) => results
    }],
    contentSources: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      onInitializeGroups: (_, {
        contentSources
      }) => contentSources
    }],
    groupsDataLoading: [true, {
      onInitializeGroups: () => false
    }],
    groupListLoading: [true, {
      setSearchResults: () => false,
      setGroupsLoading: () => true
    }],
    newGroupModalOpen: [false, {
      openNewGroupModal: () => true,
      closeNewGroupModal: () => false,
      setNewGroup: () => false
    }],
    newGroupName: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      setNewGroupName: (_, newGroupName) => newGroupName,
      setSearchResults: () => '',
      closeNewGroupModal: () => ''
    }],
    newGroup: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      setNewGroup: (_, newGroup) => newGroup,
      resetGroups: () => null,
      openNewGroupModal: () => null
    }],
    newGroupNameErrors: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      setNewGroupFormErrors: (_, newGroupNameErrors) => newGroupNameErrors,
      setNewGroup: () => [],
      setNewGroupName: () => [],
      closeNewGroupModal: () => []
    }],
    filterSourcesDropdownOpen: [false, {
      // @ts-expect-error upgrade typescript v5.1.6
      toggleFilterSourcesDropdown: state => !state,
      closeFilterSourcesDropdown: () => false
    }],
    filteredSources: [[], {
      resetGroupsFilters: () => [],
      setNewGroup: () => [],
      // @ts-expect-error upgrade typescript v5.1.6
      addFilteredSource: (state, sourceId) => [...state, sourceId].sort(),
      // @ts-expect-error upgrade typescript v5.1.6
      removeFilteredSource: (state, sourceId) => state.filter(id => id !== sourceId)
    }],
    filterValue: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      setFilterValue: (_, filterValue) => filterValue,
      resetGroupsFilters: () => ''
    }],
    groupsMeta: [_constants2.DEFAULT_META, {
      resetGroupsFilters: () => _constants2.DEFAULT_META,
      setNewGroup: () => _constants2.DEFAULT_META,
      // @ts-expect-error upgrade typescript v5.1.6
      setSearchResults: (_, {
        meta
      }) => meta,
      // @ts-expect-error upgrade typescript v5.1.6
      setActivePage: (state, activePage) => ({
        ...state,
        page: {
          ...state.page,
          current: activePage
        }
      })
    }]
  },
  selectors: ({
    selectors
  }) => ({
    hasFiltersSet: [() => [selectors.filteredSources], filteredSources => filteredSources.length > 0]
  }),
  listeners: ({
    actions,
    values
  }) => ({
    initializeGroups: async () => {
      try {
        const response = await _http.HttpLogic.values.http.get('/internal/workplace_search/groups');
        actions.onInitializeGroups(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    getSearchResults: async ({
      resetPagination
    }, breakpoint) => {
      // Debounce search results when typing
      await breakpoint(300);
      actions.setGroupsLoading();
      const {
        groupsMeta: {
          page: {
            current,
            size
          }
        },
        filterValue,
        filteredSources
      } = values;

      // Is the user changes the query while on a different page, we want to start back over at 1.
      const page = {
        current: resetPagination ? 1 : current,
        size
      };
      const search = {
        query: filterValue,
        content_source_ids: filteredSources
      };
      try {
        const response = await _http.HttpLogic.values.http.post('/internal/workplace_search/groups/search', {
          body: JSON.stringify({
            page,
            search
          }),
          headers: _constants.JSON_HEADER
        });
        actions.setSearchResults(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    saveNewGroup: async () => {
      try {
        const response = await _http.HttpLogic.values.http.post('/internal/workplace_search/groups', {
          body: JSON.stringify({
            group_name: values.newGroupName
          }),
          headers: _constants.JSON_HEADER
        });
        actions.getSearchResults(true);
        const SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.newGroupSavedSuccess', {
          defaultMessage: 'Successfully created {groupName}',
          values: {
            groupName: response.name
          }
        });
        (0, _flash_messages.flashSuccessToast)(SUCCESS_MESSAGE);
        actions.setNewGroup(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    setActivePage: () => {
      actions.getSearchResults();
    },
    openNewGroupModal: () => {
      (0, _flash_messages.clearFlashMessages)();
    },
    resetGroupsFilters: () => {
      (0, _flash_messages.clearFlashMessages)();
    },
    toggleFilterSourcesDropdown: () => {
      (0, _flash_messages.clearFlashMessages)();
    }
  })
});