"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyOrg = {};
const emptyAccount = {};
const emptySearchOAuth = {};
const AppLogic = exports.AppLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'workplace_search', 'app_logic'],
  actions: {
    initializeAppData: ({
      workplaceSearch,
      searchOAuth
    }) => ({
      workplaceSearch,
      searchOAuth
    }),
    setContext: isOrganization => isOrganization,
    setOrgName: name => name,
    setSourceRestriction: canCreatePrivateSources => canCreatePrivateSources
  },
  reducers: {
    hasInitialized: [false, {
      initializeAppData: () => true
    }],
    isOrganization: [false, {
      // @ts-expect-error upgrade typescript v5.1.6
      setContext: (_, isOrganization) => isOrganization
    }],
    organization: [emptyOrg, {
      // @ts-expect-error upgrade typescript v5.1.6
      initializeAppData: (_, {
        workplaceSearch
      }) => (workplaceSearch === null || workplaceSearch === void 0 ? void 0 : workplaceSearch.organization) || emptyOrg,
      // @ts-expect-error upgrade typescript v5.1.6
      setOrgName: (state, name) => ({
        ...state,
        name
      })
    }],
    account: [emptyAccount, {
      // @ts-expect-error upgrade typescript v5.1.6
      initializeAppData: (_, {
        workplaceSearch
      }) => (workplaceSearch === null || workplaceSearch === void 0 ? void 0 : workplaceSearch.account) || emptyAccount,
      // @ts-expect-error upgrade typescript v5.1.6
      setSourceRestriction: (state, canCreatePrivateSources) => ({
        ...state,
        canCreatePrivateSources
      })
    }],
    searchOAuth: [emptySearchOAuth, {
      // @ts-expect-error upgrade typescript v5.1.6
      initializeAppData: (_, {
        searchOAuth
      }) => searchOAuth || emptySearchOAuth
    }]
  }
});