"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineEditableTableContents = exports.InlineEditableTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _page_introduction = require("../../page_introduction/page_introduction");
var _reorderable_table = require("../reorderable_table");
var _get_updated_columns = require("./get_updated_columns");
var _inline_editable_table_logic = require("./inline_editable_table_logic");
require("./inline_editable_tables.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InlineEditableTable = props => {
  const {
    instanceId,
    columns,
    defaultItem,
    onAdd,
    onDelete,
    onReorder,
    onUpdate,
    transformItem,
    validateItem,
    ...rest
  } = props;
  return /*#__PURE__*/_react.default.createElement(_kea.BindLogic, {
    logic: _inline_editable_table_logic.InlineEditableTableLogic,
    props: {
      instanceId,
      columns,
      defaultItem,
      onAdd,
      onDelete,
      onReorder,
      onUpdate,
      transformItem,
      validateItem
    }
  }, /*#__PURE__*/_react.default.createElement(InlineEditableTableContents, (0, _extends2.default)({}, rest, {
    columns: columns
  })));
};
exports.InlineEditableTable = InlineEditableTable;
const InlineEditableTableContents = ({
  columns,
  emptyPropertyAllowed,
  items,
  title,
  addButtonText,
  canRemoveLastItem,
  className,
  description,
  isLoading,
  lastItemWarning,
  noItemsMessage = () => null,
  uneditableItems,
  ...rest
}) => {
  const {
    editingItemId,
    isEditing,
    isEditingUnsavedItem,
    rowErrors
  } = (0, _kea.useValues)(_inline_editable_table_logic.InlineEditableTableLogic);
  const {
    editNewItem,
    reorderItems
  } = (0, _kea.useActions)(_inline_editable_table_logic.InlineEditableTableLogic);

  // TODO These two things shoud just be selectors
  const isEditingItem = item => item.id === editingItemId;
  const isActivelyEditing = item => isEditing && isEditingItem(item);
  const emptyItem = {
    id: null
  };
  const displayedItems = isEditingUnsavedItem ? uneditableItems ? [emptyItem, ...items] : [...items, emptyItem] : items;
  const updatedColumns = (0, _get_updated_columns.getUpdatedColumns)({
    columns,
    displayedItems,
    emptyPropertyAllowed,
    isActivelyEditing,
    canRemoveLastItem,
    isLoading,
    lastItemWarning,
    uneditableItems
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_introduction.PageIntroduction, {
    description: description || '',
    title: title || '',
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "plusInCircle",
      disabled: isEditing,
      onClick: editNewItem,
      color: "success",
      "data-test-subj": "inlineEditableTableActionButton"
    }, addButtonText || _i18n.i18n.translate('xpack.enterpriseSearch.inlineEditableTable.newRowButtonLabel', {
      defaultMessage: 'New row'
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_reorderable_table.ReorderableTable, (0, _extends2.default)({
    className: (0, _classnames.default)(className, 'editableTable'),
    items: displayedItems,
    unreorderableItems: uneditableItems,
    columns: updatedColumns,
    rowProps: item => ({
      className: (0, _classnames.default)({
        'is-being-edited': isActivelyEditing(item)
      })
    }),
    rowErrors: item => isActivelyEditing(item) ? rowErrors : undefined,
    noItemsMessage: noItemsMessage(editNewItem),
    onReorder: reorderItems,
    disableDragging: isEditing
  }, rest)));
};
exports.InlineEditableTableContents = InlineEditableTableContents;