"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFound = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/constants");
var _not_found = require("../../../shared/not_found");
var _telemetry = require("../../../shared/telemetry");
var _layout = require("../layout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotFound = ({
  pageChrome = []
}) => {
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchRelevancePageTemplate, {
    pageChrome: [...pageChrome, '404'],
    customPageSections: true
  }, /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "error",
    metric: "not_found"
  }), /*#__PURE__*/_react.default.createElement(_not_found.NotFoundPrompt, {
    productSupportUrl: _constants.SEARCH_RELEVANCE_PLUGIN.SUPPORT_URL
  }));
};
exports.NotFound = NotFound;